/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.services.Session;
import gov.ornl.mercury3.services.SessionId;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SessionDAO
extends HibernateDaoSupport {
    private static final Log log = LogFactory.getLog(SessionDAO.class);

    protected void initDao() {
    }

    public void save(Session transientInstance) {
        log.debug((Object)"saving Session instance");
        try {
            this.getHibernateTemplate().save((Object)transientInstance);
            log.debug((Object)"save successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"save failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(Session persistentInstance) {
        log.debug((Object)"deleting Session instance");
        try {
            this.getHibernateTemplate().delete((Object)persistentInstance);
            log.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public Session findById(SessionId id) {
        log.debug((Object)("getting Session instance with id: " + id));
        try {
            Session instance = (Session)this.getHibernateTemplate().get("gov.ornl.mercury3.services.Session", (Serializable)id);
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List findByExample(Session instance) {
        log.debug((Object)"finding Session instance by example");
        try {
            List results = this.getHibernateTemplate().findByExample((Object)instance);
            log.debug((Object)("find by example successful, result size: " + results.size()));
            return results;
        }
        catch (RuntimeException re) {
            log.error((Object)"find by example failed", (Throwable)re);
            throw re;
        }
    }

    public List findByProperty(String propertyName, Object value) {
        log.debug((Object)("finding Session instance with property: " + propertyName + ", value: " + value));
        try {
            String queryString = "from Session as model where model." + propertyName + "= ?";
            return this.getHibernateTemplate().find(queryString, value);
        }
        catch (RuntimeException re) {
            log.error((Object)"find by property name failed", (Throwable)re);
            throw re;
        }
    }

    public List findAll() {
        log.debug((Object)"finding all Session instances");
        try {
            String queryString = "from Session";
            return this.getHibernateTemplate().find(queryString);
        }
        catch (RuntimeException re) {
            log.error((Object)"find all failed", (Throwable)re);
            throw re;
        }
    }

    public Session merge(Session detachedInstance) {
        log.debug((Object)"merging Session instance");
        try {
            Session result = (Session)this.getHibernateTemplate().merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(Session instance) {
        log.debug((Object)"attaching dirty Session instance");
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)instance);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(Session instance) {
        log.debug((Object)"attaching clean Session instance");
        try {
            this.getHibernateTemplate().lock((Object)instance, LockMode.NONE);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public static SessionDAO getFromApplicationContext(ApplicationContext ctx) {
        return (SessionDAO)((Object)ctx.getBean("SessionDAO"));
    }
}

