/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.services.Query;
import gov.ornl.mercury3.services.QueryId;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class QueryDAO
extends HibernateDaoSupport {
    private static final Log log = LogFactory.getLog(QueryDAO.class);

    protected void initDao() {
    }

    public void save(Query transientInstance) {
        log.debug((Object)"saving Query instance");
        try {
            this.getHibernateTemplate().save((Object)transientInstance);
            log.debug((Object)"save successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"save failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(Query persistentInstance) {
        log.debug((Object)"deleting Query instance");
        try {
            this.getHibernateTemplate().delete((Object)persistentInstance);
            log.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public Query findById(QueryId id) {
        log.debug((Object)("getting Query instance with id: " + id));
        try {
            Query instance = (Query)this.getHibernateTemplate().get("gov.ornl.mercury3.services.Query", (Serializable)id);
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List findByExample(Query instance) {
        log.debug((Object)"finding Query instance by example");
        try {
            List results = this.getHibernateTemplate().findByExample((Object)instance);
            log.debug((Object)("find by example successful, result size: " + results.size()));
            return results;
        }
        catch (RuntimeException re) {
            log.error((Object)"find by example failed", (Throwable)re);
            throw re;
        }
    }

    public List findByProperty(String propertyName, Object value) {
        log.debug((Object)("finding Query instance with property: " + propertyName + ", value: " + value));
        try {
            String queryString = "from Query as model where model." + propertyName + "= ?";
            return this.getHibernateTemplate().find(queryString, value);
        }
        catch (RuntimeException re) {
            log.error((Object)"find by property name failed", (Throwable)re);
            throw re;
        }
    }

    public List findAll() {
        log.debug((Object)"finding all Query instances");
        try {
            String queryString = "from Query";
            return this.getHibernateTemplate().find(queryString);
        }
        catch (RuntimeException re) {
            log.error((Object)"find all failed", (Throwable)re);
            throw re;
        }
    }

    public Query merge(Query detachedInstance) {
        log.debug((Object)"merging Query instance");
        try {
            Query result = (Query)this.getHibernateTemplate().merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(Query instance) {
        log.debug((Object)"attaching dirty Query instance");
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)instance);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(Query instance) {
        log.debug((Object)"attaching clean Query instance");
        try {
            this.getHibernateTemplate().lock((Object)instance, LockMode.NONE);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public static QueryDAO getFromApplicationContext(ApplicationContext ctx) {
        return (QueryDAO)((Object)ctx.getBean("QueryDAO"));
    }
}

