/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.services;

import gov.ornl.mercury3.commands.Tokenz;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Mercury3_EditBoxParser {
    private String fSearchText;
    private String facet;
    private static final Set<String> fBOOL_WORDS = new HashSet<String>();
    private static final String fDOUBLE_QUOTE = "\"";
    private static final String fWHITESPACE_AND_QUOTES = " \t\r\n\"";
    private static final String fQUOTES_ONLY = "\"";

    public static void main(String ... aArguments) {
        try {
            Mercury3_EditBoxParser parser = new Mercury3_EditBoxParser("mars and (venus) \"milky or way\" sun \" some obscure (title) and such \" or another ");
            List<Tokenz> ltz = parser.parseSearchText();
            System.out.println(parser.getStringwithBools(ltz));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getStringwithBools(List<Tokenz> ltz) {
        String escapeChars = "[\\\\+\\!\\(\\)\\:\\^\\]\\{\\}\\~\\?]";
        Tokenz t1 = new Tokenz();
        String searchr = "";
        String searchr2 = "";
        StringBuffer sb = new StringBuffer();
        String aToken = "";
        for (int i = 0; i < ltz.size(); ++i) {
            t1 = ltz.get(i);
            String typer = t1.getTokenType();
            boolean b1 = Boolean.parseBoolean(typer);
            aToken = t1.getTokenText().trim();
            if (aToken.equals("(") || aToken.equals(")") || aToken.equals("OR") || aToken.equals("AND")) {
                searchr2 = aToken + " ";
            } else if (b1) {
                searchr2 = aToken.endsWith(")") || aToken.startsWith("(") ? this.facet + " : " + aToken + " " : this.facet + " : " + aToken.replaceAll(escapeChars, "\\\\$0") + " ";
                System.out.println(" b1 searchr2 =>" + searchr2);
            } else {
                searchr2 = this.facet + " : \"" + aToken + "\"";
                System.out.println(" !b1 searchr2 =>" + searchr2);
            }
            sb.append(searchr2);
        }
        return sb.toString();
    }

    public Mercury3_EditBoxParser(String aSearchText) {
        if (aSearchText == null) {
            throw new IllegalArgumentException("Search Text cannot be null.");
        }
        this.fSearchText = aSearchText;
    }

    public Mercury3_EditBoxParser(String aSearchText, String afacet) {
        if (aSearchText == null) {
            throw new IllegalArgumentException("Search Text cannot be null.");
        }
        this.fSearchText = aSearchText;
        this.facet = afacet;
    }

    public List<Tokenz> parseSearchText() {
        ArrayList<Tokenz> result3 = new ArrayList<Tokenz>();
        boolean returnTokens = true;
        String currentDelims = fWHITESPACE_AND_QUOTES;
        StringTokenizer parser = new StringTokenizer(this.fSearchText, currentDelims, returnTokens);
        String token = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken(currentDelims);
            if (!this.isDoubleQuote(token)) {
                this.addTokensToResult(token, result3, currentDelims, this.facet);
                continue;
            }
            currentDelims = this.flipDelimiters(currentDelims);
        }
        return result3;
    }

    public List<Tokenz> parseSearchText(String querystring) {
        ArrayList<Tokenz> result3 = new ArrayList<Tokenz>();
        boolean returnTokens = true;
        String currentDelims = fWHITESPACE_AND_QUOTES;
        StringTokenizer parser = new StringTokenizer(querystring, currentDelims, returnTokens);
        String token = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken(currentDelims);
            if (!this.isDoubleQuote(token)) {
                this.addTokensToResult(token, result3, currentDelims, this.facet);
                continue;
            }
            currentDelims = this.flipDelimiters(currentDelims);
        }
        return result3;
    }

    public List<Tokenz> parseSearchText_adv() {
        boolean b1 = false;
        StringBuffer sb = new StringBuffer();
        String typer = null;
        String nu_qryStr = null;
        ArrayList<Tokenz> result3 = new ArrayList<Tokenz>();
        boolean returnTokens = true;
        String currentDelims = fWHITESPACE_AND_QUOTES;
        StringTokenizer parser = new StringTokenizer(this.fSearchText, currentDelims, returnTokens);
        String token = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken(currentDelims);
            if (!this.isDoubleQuote(token)) {
                this.addTokensToResult(token, result3, currentDelims, this.facet);
                continue;
            }
            currentDelims = this.flipDelimiters(currentDelims);
        }
        for (Tokenz tk : result3) {
            typer = tk.getTokenType();
            b1 = Boolean.parseBoolean(typer);
            if (!b1) {
                sb.append(" \" " + tk.getTokenText() + " \" ");
            } else {
                sb.append(" " + tk.getTokenText().replace("(", " ( ").replace(")", " ) "));
            }
            nu_qryStr = sb.toString();
        }
        try {
            PrintStream out8 = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out8.println("old fSearchText => " + this.fSearchText + "\n");
            out8.println("nu_qryStr => " + nu_qryStr + "\n");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        List<Tokenz> result4 = this.parseSearchText(nu_qryStr);
        return result4;
    }

    private boolean isBoolWord(String aSearchTokenCandidate) {
        return fBOOL_WORDS.contains(aSearchTokenCandidate);
    }

    private boolean textHasContent(String aText) {
        return aText != null && !aText.trim().equals("");
    }

    private void addTokensToResult(String aToken, List<Tokenz> aResult3, String currentDelims) {
        String type = "";
        if (this.textHasContent(aToken) && !this.isBoolWord(aToken.trim())) {
            type = Boolean.toString(!currentDelims.equals("\""));
            aResult3.add(new Tokenz(type, aToken.trim()));
        } else if (this.textHasContent(aToken) && this.isBoolWord(aToken.trim())) {
            type = Boolean.toString(!currentDelims.equals("\""));
            aResult3.add(new Tokenz(type, aToken.trim().toUpperCase()));
        }
    }

    private void addTokensToResult(String aToken, List<Tokenz> aResult3, String currentDelims, String facet) {
        String type = "";
        if (this.textHasContent(aToken) && !this.isBoolWord(aToken.trim())) {
            type = Boolean.toString(!currentDelims.equals("\""));
            aResult3.add(new Tokenz(type, aToken.trim()));
        } else if (this.textHasContent(aToken) && this.isBoolWord(aToken.trim())) {
            type = Boolean.toString(!currentDelims.equals("\""));
            aResult3.add(new Tokenz(type, aToken.trim().toUpperCase()));
        }
    }

    private boolean isDoubleQuote(String aToken) {
        return aToken.equals("\"");
    }

    private String flipDelimiters(String aCurrentDelims) {
        String result = null;
        result = aCurrentDelims.equals(fWHITESPACE_AND_QUOTES) ? "\"" : fWHITESPACE_AND_QUOTES;
        return result;
    }

    static {
        fBOOL_WORDS.add("or");
        fBOOL_WORDS.add("and");
    }
}

