/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.email_utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    ByteArrayDataSource(String data, String type) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.type = type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return "dummy";
    }
}

