/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.dwr_utils;

import gov.ornl.mercury3.dwr_utils.DateUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ErrorLogUtil {
    public static final String ERROR_PROPERTY_FILE = "ErrorLogUtil.properties";
    public static final String LOG_ROOT = "LogRoot";
    public static final String IS_DEBUG = "DEBUG";
    static SimpleDateFormat formatterDate = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
    private static ErrorLogUtil instance;
    private static Properties properties;
    private static FileWriter fw;
    private static PrintWriter pw;
    DateUtil dateUtil = DateUtil.getInstance();

    public static synchronized ErrorLogUtil getInstance() {
        if (instance == null) {
            instance = new ErrorLogUtil();
        }
        return instance;
    }

    private ErrorLogUtil() {
    }

    public boolean isDebug() {
        return properties.getProperty(IS_DEBUG).equals("TRUE");
    }

    private String getLogRoot() {
        return properties.getProperty(LOG_ROOT);
    }

    private String getLogFile(int projectID) {
        String logRoot = this.getLogRoot();
        String logFile = properties.getProperty("" + projectID);
        return logRoot + logFile;
    }

    public void writeToLog(String message, Object objectRef, int projectID) {
        try {
            fw = new FileWriter(this.getLogFile(projectID) + this.dateUtil.dateToString(new Date(), ".yyyy-MM-dd") + ".txt", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pw = new PrintWriter(fw);
        pw.println(formatterDate.format(new Date()) + ":" + objectRef.getClass().getName() + " Message:" + message);
        pw.flush();
    }

    public void writeToLog(String message, String classRef, int projectID) {
        try {
            fw = new FileWriter(this.getLogFile(projectID) + this.dateUtil.dateToString(new Date(), ".yyyy-MM-dd") + ".txt", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pw = new PrintWriter(fw);
        pw.println(formatterDate.format(new Date()) + ":" + classRef + " Message:" + message);
        pw.flush();
    }

    public void writeToLog(String message, Object objectRef, String projectID) {
        try {
            fw = new FileWriter(this.getLogRoot() + projectID + ".log" + this.dateUtil.dateToString(new Date(), ".yyyy-MM-dd") + ".txt", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pw = new PrintWriter(fw);
        pw.println(formatterDate.format(new Date()) + ":" + objectRef.getClass().getName() + " Message:" + message);
        pw.flush();
    }

    public void writeToLog(String message, String classRef, String projectID) {
        try {
            fw = new FileWriter(this.getLogRoot() + projectID + ".log" + this.dateUtil.dateToString(new Date(), ".yyyy-MM-dd") + ".txt", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pw = new PrintWriter(fw);
        pw.println(formatterDate.format(new Date()) + ":" + classRef + " Message:" + message);
        pw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        properties = null;
        fw = null;
        pw = null;
        String propertyFile = ErrorLogUtil.getInstance().getClass().getResource(ERROR_PROPERTY_FILE).getFile();
        properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertyFile);
            properties.load(is);
        }
        catch (FileNotFoundException fe) {
            System.err.println(fe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

