/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.dwr_utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class DateUtil {
    private static DateUtil instance;
    static SimpleDateFormat formatterDate;
    static final long ONE_HOUR = 3600000L;

    public static synchronized DateUtil getInstance() {
        if (instance == null) {
            instance = new DateUtil();
        }
        return instance;
    }

    private DateUtil() {
    }

    public int getDate(String calDate, String value) {
        int date = 0;
        int month = 0;
        int year = 9999;
        int returnValue = 0;
        StringTokenizer st = new StringTokenizer(calDate, "-");
        while (st.hasMoreTokens()) {
            month = Integer.parseInt(st.nextToken());
            date = Integer.parseInt(st.nextToken());
            year = Integer.parseInt(st.nextToken());
        }
        if (value.equals("GETDATE")) {
            returnValue = date;
        } else if (value.equals("GETMONTH")) {
            returnValue = month;
        } else if (value.equals("GETYEAR")) {
            returnValue = year;
        }
        return returnValue;
    }

    public Date toDate(String dateString) {
        return this.toDate(dateString, "MM-dd-yyyy");
    }

    public Date toDate(String dateString, String format) {
        Date aDate = null;
        SimpleDateFormat tdateForm = new SimpleDateFormat(format);
        try {
            return tdateForm.parse(dateString);
        }
        catch (Exception e) {
            try {
                aDate = tdateForm.parse("01/01/22");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return aDate;
        }
    }

    public long daysBetween(Date d1, Date d2) {
        return (d2.getTime() - d1.getTime() + 3600000L) / 86400000L;
    }

    public Calendar dateToCalendar(Date date) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(date);
        return calendarDate;
    }

    public Calendar stringToCalendar(String strDate) {
        Calendar calendarDate = Calendar.getInstance();
        try {
            SimpleDateFormat ksdf = new SimpleDateFormat("yyyy-MM-dd");
            calendarDate.setTime(ksdf.parse(strDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendarDate;
    }

    public Calendar stringToCalendar(String strDate, String strFormat) {
        Calendar calendarDate = Calendar.getInstance();
        try {
            SimpleDateFormat ksdf = new SimpleDateFormat(strFormat);
            calendarDate.setTime(ksdf.parse(strDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendarDate;
    }

    public String dateToString(Date aDate) {
        return this.dateToString(aDate, "MM/dd/yyyy");
    }

    public String dateToString(Date aDate, String format) {
        SimpleDateFormat dateForm = new SimpleDateFormat(format);
        return dateForm.format(aDate);
    }

    public String dateToString(Calendar calendarDate) {
        return this.dateToString(calendarDate, "yyyy-MM-dd");
    }

    public String dateToString(Calendar calendarDate, String outPutFormat) {
        String l_output;
        if (calendarDate != null) {
            Date l_date = calendarDate.getTime();
            SimpleDateFormat l_formatter = new SimpleDateFormat(outPutFormat);
            l_output = l_formatter.format(l_date);
        } else {
            l_output = "Date unknown";
        }
        return l_output;
    }

    public String getMonthString(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "January";
    }

    static {
        formatterDate = new SimpleDateFormat("dd-MMM-yy");
    }
}

