/*
 * Decompiled with CFR 0.152.
 */
package gov.ornl.mercury3.commands;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

public class CoinsBean {
    private String pid = "";
    private String dataUrl = "";
    private String title = "";
    private String citationDate = "";
    private String author = "";
    private String abstractText = "";
    private String datasource = "";
    private ArrayList<String> keywords = new ArrayList();
    private ArrayList<String> additionalInvestigators = new ArrayList();

    public CoinsBean() {
    }

    public CoinsBean(String pid, String dataUrl, String title, String citationDate, String author, String abstractText, String datasource, ArrayList<String> keywords) {
        this.pid = pid;
        this.dataUrl = dataUrl;
        this.title = title;
        this.citationDate = citationDate;
        this.author = author;
        this.abstractText = abstractText;
        this.datasource = datasource;
        this.keywords = keywords;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCitationDate() {
        return this.citationDate;
    }

    public void setCitationDate(String citationDate) {
        this.citationDate = citationDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAbstractText() {
        return this.abstractText;
    }

    public void setAbstractText(String abstractText) {
        if (abstractText != null && abstractText.length() > 600) {
            this.abstractText = abstractText.substring(0, 600);
        }
        this.abstractText = abstractText;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public ArrayList<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(ArrayList<String> keywords) {
        this.keywords = keywords;
    }

    public void setKeywordsFromJsonArray(JSONArray keywordsArray) {
        for (int i = 0; i < keywordsArray.length(); ++i) {
            try {
                this.keywords.add(keywordsArray.getString(i));
                continue;
            }
            catch (JSONException jse) {
                System.out.println("ERROR: could not get keyword from array");
            }
        }
    }

    public ArrayList<String> getAdditionalInvestigators() {
        return this.additionalInvestigators;
    }

    public void setAdditionalInvestigators(ArrayList<String> additionalInvestigators) {
        String author = this.getAuthor();
        for (String investigator : additionalInvestigators) {
            if (author == null || investigator == null || author.contains(investigator)) continue;
            this.additionalInvestigators.add(investigator);
        }
        this.additionalInvestigators = additionalInvestigators;
    }

    public void setAdditionalInvestigatorsFromJsonArray(JSONArray investigatorsArray) {
        String author = this.getAuthor();
        for (int i = 0; i < investigatorsArray.length(); ++i) {
            try {
                String investigator = investigatorsArray.getString(i);
                if (author == null || investigator == null || author.contains(investigator)) continue;
                this.additionalInvestigators.add(investigator);
                continue;
            }
            catch (JSONException jse) {
                System.out.println("ERROR: could not get investigator from array");
            }
        }
    }
}

