/*
 * Decompiled with CFR 0.152.
 */
package gov.mercury3.memberNode.resource;

import gov.ornl.mercury3.commands.Configuration;
import java.io.IOException;
import java.util.HashMap;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PingResource
extends ServerResource {
    private String itemName;
    private String ping_id;

    protected void doInit() throws ResourceException {
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        HashMap<String, Object> hmProps = cv.getProperties();
        this.ping_id = (String)hmProps.get("ping");
    }

    public Representation get() {
        FileRepresentation representation = new FileRepresentation(this.ping_id, MediaType.TEXT_HTML, 3600);
        return representation;
    }

    protected Representation get1() throws ResourceException {
        DomRepresentation result;
        try {
            result = new DomRepresentation();
            result.setIndenting(true);
            Document doc = result.getDocument();
            Element mnElt = doc.createElement("systemMetadata");
            doc.appendChild(mnElt);
            Element idElt = doc.createElement("identifier");
            idElt.setTextContent("Identifier0");
            mnElt.appendChild(idElt);
            Element formatElt = doc.createElement("objectFormat");
            formatElt.setTextContent("eml://ecoinformatics.org/eml-2.0.1");
            mnElt.appendChild(formatElt);
            Element dateUploadedElt = doc.createElement("dateUploaded");
            dateUploadedElt.setTextContent("2006-05-04T18:13:51.0Z");
            mnElt.appendChild(dateUploadedElt);
            Element originElt = doc.createElement("originMemberNode");
            originElt.setTextContent(new Reference(this.getReference(), "..").getTargetRef().toString());
            mnElt.appendChild(originElt);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        DomRepresentation mnRep = new DomRepresentation(representation);
        String doi = mnRep.getText("/systemMetadata/identifier");
        System.out.println("doi: " + doi);
        return null;
    }
}

