/*
 * Decompiled with CFR 0.152.
 */
package gov.mercury3.memberNode.resource;

import gov.ornl.mercury3.commands.Configuration;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.restlet.data.MediaType;
import org.restlet.ext.jibx.JibxRepresentation;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class ObjectResource
extends ServerResource {
    public String fsep = File.separator;
    SolrCore core;
    private String msolrhome;
    private String mcore;
    private String pid;
    private String d1_md;
    private String requestCount;
    private String requestStart;
    private String requestFormat;
    private String requestStartTime;
    private String requestEndTime;
    private String requestReplicaStatus;

    protected void doInit() throws ResourceException {
        this.pid = (String)this.getRequestAttributes().get("pid");
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        HashMap<String, Object> hmProps = cv.getProperties();
        this.d1_md = (String)hmProps.get("d1_md");
        this.msolrhome = (String)hmProps.get("msolrhome");
        this.mcore = (String)hmProps.get("mcore");
    }

    protected Representation get() throws ResourceException {
        String dateString = "";
        QueryResponse qrs2 = this.query3("water");
        SolrDocumentList sdl = qrs2.getResults();
        Long numfound = sdl.getNumFound();
        Long start = sdl.getStart();
        Long count = sdl.getNumFound();
        ObjectInfo oi1 = new ObjectInfo();
        ObjectList ol1 = new ObjectList();
        Identifier identifier = new Identifier();
        ol1.setStart(start.intValue());
        ol1.setTotal(numfound.intValue());
        ol1.setCount(sdl.size());
        String fmt = "";
        Checksum checksum = new Checksum();
        checksum.setAlgorithm("MD5");
        checksum.setValue("bada55");
        Date dateSysMetadataModified = new Date();
        String algorithm = "";
        for (SolrDocument d : sdl) {
            oi1 = new ObjectInfo();
            identifier = new Identifier();
            identifier.setValue((String)d.get((Object)"identifier"));
            fmt = (String)d.get((Object)"objectFormat");
            ObjectFormat objectFormat = ObjectFormat.convert(fmt);
            ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
            String fmt2 = objectFormat.value;
            fmtid.setValue(fmt2);
            checksum = new Checksum();
            algorithm = (String)d.get((Object)"checksumAlgorithm");
            checksum.setAlgorithm((String)d.get((Object)"checksumAlgorithm"));
            checksum.setValue((String)d.get((Object)"checksum"));
            dateSysMetadataModified = (Date)d.get((Object)"last_modified");
            oi1.setIdentifier(identifier);
            oi1.setSize(BigInteger.valueOf(Long.parseLong((String)d.get((Object)"size"))));
            oi1.setChecksum(checksum);
            oi1.setDateSysMetadataModified(dateSysMetadataModified);
            oi1.setFormatId(fmtid);
            ol1.addObjectInfo(oi1);
        }
        JibxRepresentation result2 = new JibxRepresentation(MediaType.TEXT_XML, (Object)ol1);
        return result2;
    }

    protected Representation put(Representation representation) throws ResourceException {
        DomRepresentation mnRep = new DomRepresentation(representation);
        String doi = mnRep.getText("/systemMetadata/identifier");
        System.out.println("doi: " + doi);
        return null;
    }

    public QueryResponse query3(String q) {
        this.requestCount = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("count");
        this.requestStart = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("start");
        this.requestFormat = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("objectFormat");
        this.requestStartTime = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("startTime");
        this.requestEndTime = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("endTime");
        this.requestReplicaStatus = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("replicaStatus");
        String msolrhome2 = this.msolrhome.concat(this.fsep).concat(this.mcore);
        EmbeddedSolrServer server2 = null;
        CoreContainer container = new CoreContainer();
        server2 = new EmbeddedSolrServer(container, this.mcore);
        SolrConfig config = null;
        try {
            config = new SolrConfig(msolrhome2, "solrconfig.xml", null);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        CoreDescriptor descriptor = new CoreDescriptor(container, this.mcore, this.msolrhome);
        this.core = new SolrCore(this.mcore, msolrhome2 + this.fsep + "data", config, null, descriptor);
        container.register(this.mcore, this.core, false);
        QueryResponse qrs2 = null;
        try {
            String query2 = "";
            StringBuilder sb = new StringBuilder();
            sb.append("*:*");
            if (null != this.requestFormat && this.requestFormat.length() > 0) {
                sb.append(" AND objectFormat:" + this.requestFormat);
            }
            query2 = sb.toString();
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("q", new String[]{query2});
            if (null != this.requestStart) {
                solrParams.set("start", Integer.parseInt(this.requestStart));
            } else {
                solrParams.set("start", 0);
            }
            if (null != this.requestCount) {
                solrParams.set("rows", Integer.parseInt(this.requestCount));
            } else {
                solrParams.set("rows", 10);
            }
            solrParams.add("size", new String[]{"identifier", "checksumAlgorithm", "objectFormat", "checksum", "update_date"});
            qrs2 = server2.query((SolrParams)solrParams);
            System.out.println("Query2 Results: " + qrs2);
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        container.shutdown();
        return qrs2;
    }

    static enum ObjectFormat {
        EML_2_0_0("eml://ecoinformatics.org/eml-2.0.0"),
        EML_2_0_1("eml://ecoinformatics.org/eml-2.0.1"),
        EML_2_1_0("eml://ecoinformatics.org/eml-2.1.0"),
        EML_2_1_1("eml://ecoinformatics.org/eml-2.1.1"),
        FGDC_STD_001_1_1999("FGDC-STD-001.1-1999"),
        FGDC_STD_001_1998("FGDC-STD-001-1998"),
        INCITS_453_2009("INCITS 453-2009"),
        NCML_2_2("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2"),
        CF_1_0("CF-1.0"),
        CF_1_1("CF-1.1"),
        CF_1_2("CF-1.2"),
        CF_1_3("CF-1.3"),
        CF_1_4("CF-1.4"),
        WATER_ML_1_0("http://www.cuahsi.org/waterML/1.0/"),
        WATER_ML_1_1("http://www.cuahsi.org/waterML/1.1/"),
        DSPACE_METS_SIP_1_0("http://www.loc.gov/METS/"),
        NET_CDF_3("netCDF-3"),
        NET_CDF_4("netCDF-4"),
        TEXT_PLAIN("text/plain"),
        TEXT_CSV("text/csv"),
        IMAGE_BMP("image/bmp"),
        IMAGE_GIF("image/gif"),
        IMAGE_JP2("image/jp2"),
        IMAGE_JPEG("image/jpeg"),
        IMAGE_PNG("image/png"),
        IMAGE_SVGXML("image/svg+xml"),
        IMAGE_TIFF("image/tiff"),
        SIMPLE_DARWIN_CORE("http://rs.tdwg.org/dwc/xsd/simpledarwincore/"),
        DARWIN_2("http://digir.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd"),
        OCTET_STREAM("application/octet-stream");

        private final String value;

        private ObjectFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static ObjectFormat convert(String value) {
            for (ObjectFormat inst : ObjectFormat.values()) {
                if (!inst.toString().equals(value)) continue;
                return inst;
            }
            return OCTET_STREAM;
        }
    }
}

