/*
 * Decompiled with CFR 0.152.
 */
package gov.mercury3.memberNode.resource;

import gov.ornl.mercury3.commands.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HTMLResource
extends ServerResource {
    private String itemName;
    private String d1_md;
    private static final Logger LOG = LoggerFactory.getLogger(HTMLResource.class);

    protected void doInit() throws ResourceException {
        this.itemName = (String)this.getRequestAttributes().get("itemName");
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("Mercury3Properties.xml");
        Configuration cv = (Configuration)factory.getBean("propertiesBean");
        HashMap<String, Object> hmProps = cv.getProperties();
        this.d1_md = (String)hmProps.get("d1_md");
    }

    protected Representation get() throws ResourceException {
        FileRepresentation representation = null;
        Disposition attachment = new Disposition("attachment");
        attachment.setFilename(this.itemName);
        try {
            FileInputStream fis = new FileInputStream(new File(this.d1_md + this.itemName));
            representation = this.itemName.endsWith("xml") ? new FileRepresentation(this.d1_md + this.itemName, MediaType.APPLICATION_ALL_XML, 3600) : (this.itemName.endsWith("zip") ? new FileRepresentation(this.d1_md + this.itemName, MediaType.APPLICATION_ZIP, 3600) : new FileRepresentation(this.d1_md + this.itemName, MediaType.TEXT_HTML, 3600));
        }
        catch (FileNotFoundException e) {
            LOG.error("File '{}' not found.");
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        representation.setDisposition(attachment);
        return representation;
    }
}

