/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestNode
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);
    private static final AnonId A = AnonId.create();
    static String[] someURIs = new String[]{"http://domainy.thing/stuff/henry", "http://whatever.com/stingy-beast/bee", "ftp://erewhon/12345", "potatoe:rhubarb"};
    protected static String[] someNodes = new String[]{"42", "'hello'", "_anon", "'robotic'tick", "'teriffic'abc:def"};

    public TestNode(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNode.class);
    }

    public void testBlanks() {
        TestNode.assertTrue((String)"anonymous nodes are blank", (boolean)Node.createAnon().isBlank());
        TestNode.assertFalse((String)"anonymous nodes aren't literal", (boolean)Node.createAnon().isLiteral());
        TestNode.assertFalse((String)"anonymous nodes aren't URIs", (boolean)Node.createAnon().isURI());
        TestNode.assertFalse((String)"anonymous nodes aren't variables", (boolean)Node.createAnon().isVariable());
        TestNode.assertEquals((String)"anonymous nodes have the right id", (Object)Node.createAnon((AnonId)A).getBlankNodeId(), (Object)A);
    }

    public void testLiterals() {
        TestNode.assertFalse((String)"literal nodes aren't blank", (boolean)Node.createLiteral((LiteralLabel)L).isBlank());
        TestNode.assertTrue((String)"literal nodes are literal", (boolean)Node.createLiteral((LiteralLabel)L).isLiteral());
        TestNode.assertFalse((String)"literal nodes aren't variables", (boolean)Node.createLiteral((LiteralLabel)L).isVariable());
        TestNode.assertFalse((String)"literal nodes aren't URIs", (boolean)Node.createLiteral((LiteralLabel)L).isURI());
        TestNode.assertEquals((String)"literal nodes preserve value", (Object)Node.createLiteral((LiteralLabel)L).getLiteral(), (Object)L);
    }

    public void testURIs() {
        TestNode.assertFalse((String)"URI nodes aren't blank", (boolean)Node.createURI((String)U).isBlank());
        TestNode.assertFalse((String)"URI nodes aren't literal", (boolean)Node.createURI((String)U).isLiteral());
        TestNode.assertFalse((String)"URI nodes aren't variables", (boolean)Node.createURI((String)U).isVariable());
        TestNode.assertTrue((String)"URI nodes are URIs", (boolean)Node.createURI((String)U).isURI());
        TestNode.assertEquals((String)"URI nodes preserve URI", (String)Node.createURI((String)U).getURI(), (String)U);
    }

    public void testVariables() {
        TestNode.assertFalse((String)"variable nodes aren't blank", (boolean)Node.createVariable((String)N).isBlank());
        TestNode.assertFalse((String)"variable nodes aren't literal", (boolean)Node.createVariable((String)N).isLiteral());
        TestNode.assertFalse((String)"variable nodes aren't URIs", (boolean)Node.createVariable((String)N).isURI());
        TestNode.assertTrue((String)"variable nodes are variable", (boolean)Node.createVariable((String)N).isVariable());
        TestNode.assertEquals((String)"variable nodes keep their name", (String)N, (String)Node.createVariable((String)N).getName());
        TestNode.assertEquals((String)"variable nodes keep their name", (String)"Alicex", (String)Node.createVariable((String)"Alicex").getName());
    }

    public void testANY() {
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
        TestNode.assertFalse((String)"ANY nodes aren't literals", (boolean)Node.ANY.isLiteral());
        TestNode.assertFalse((String)"ANY nodes aren't URIs", (boolean)Node.ANY.isURI());
        TestNode.assertFalse((String)"ANY nodes aren't variables", (boolean)Node.ANY.isVariable());
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
    }

    public void testNodeVariableConstructor() {
        TestNode.assertEquals((Object)Node.createVariable((String)"hello"), (Object)new Node_Variable("hello"));
        TestNode.assertEquals((Object)Node.createVariable((String)"world"), (Object)new Node_Variable("world"));
        TestNode.assertDiffer(Node.createVariable((String)"hello"), new Node_Variable("world"));
        TestNode.assertEquals((String)"myName", (String)new Node_Variable("myName").getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] eqTestCases() {
        try {
            Node.cache((boolean)false);
            AnonId id = AnonId.create();
            LiteralLabel L2 = new LiteralLabel(id.toString(), "", false);
            LiteralLabel LLang1 = new LiteralLabel((Object)"xyz", "en", null);
            LiteralLabel LLang2 = new LiteralLabel((Object)"xyz", "EN", null);
            String U2 = id.toString();
            String N2 = id.toString();
            Object[][] objectArray = new Object[][]{{Node.ANY, "0"}, {Node.createAnon((AnonId)id), "1"}, {Node.createAnon(), "2"}, {Node.createAnon((AnonId)id), "1"}, {Node.createLiteral((LiteralLabel)L), "3"}, {Node.createLiteral((LiteralLabel)L2), "4"}, {Node.createLiteral((LiteralLabel)L), "3"}, {Node.createURI((String)U), "5"}, {Node.createURI((String)U2), "6"}, {Node.createURI((String)U), "5"}, {Node.createVariable((String)N), "7"}, {Node.createVariable((String)N2), "8"}, {Node.createVariable((String)N), "7"}, {Node.createLiteral((LiteralLabel)LLang1), "9"}, {Node.createLiteral((LiteralLabel)LLang2), "10"}};
            return objectArray;
        }
        finally {
            Node.cache((boolean)true);
        }
    }

    public void testNodeEquals() {
        Object[][] tests = this.eqTestCases();
        for (int i = 0; i < tests.length; ++i) {
            Object[] I = tests[i];
            TestNode.assertFalse((String)(I[0] + " should not equal null"), (boolean)I[0].equals(null));
            TestNode.assertFalse((String)(I[0] + "should not equal 'String'"), (boolean)I[0].equals("String"));
            for (int j = 0; j < tests.length; ++j) {
                Object[] J = tests[j];
                this.testEquality(I[1].equals(J[1]), I[0], J[0]);
            }
        }
    }

    private void testEquality(boolean testEq, Object x, Object y) {
        String testName = this.getType(x) + " " + x + " and " + this.getType(y) + " " + y;
        if (testEq) {
            TestNode.assertEquals((String)(testName + "should be equal"), (Object)x, (Object)y);
        } else {
            TestNode.assertDiffer(testName + " should differ", x, y);
        }
    }

    private String getType(Object x) {
        String fullName = x.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquals() {
        try {
            Node.cache((boolean)false);
            TestNode.assertDiffer("different variables", Node.createVariable((String)"xx"), Node.createVariable((String)"yy"));
            TestNode.assertEquals((String)"same vars", (Object)Node.createVariable((String)"aa"), (Object)Node.createVariable((String)"aa"));
            TestNode.assertEquals((String)"same URI", (Object)Node.createURI((String)U), (Object)Node.createURI((String)U));
            TestNode.assertEquals((String)"same anon", (Object)Node.createAnon((AnonId)A), (Object)Node.createAnon((AnonId)A));
            TestNode.assertEquals((String)"same literal", (Object)Node.createLiteral((LiteralLabel)L), (Object)Node.createLiteral((LiteralLabel)L));
            TestNode.assertFalse((String)"distinct URIs", (Node.createURI((String)U) == Node.createURI((String)U) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct hyphens", (Node.createAnon((AnonId)A) == Node.createAnon((AnonId)A) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct literals", (Node.createLiteral((LiteralLabel)L) == Node.createLiteral((LiteralLabel)L) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct vars", (Node.createVariable((String)"aa") == Node.createVariable((String)"aa") ? 1 : 0) != 0);
        }
        finally {
            Node.cache((boolean)true);
        }
    }

    public void testLabels() {
        AnonId id = AnonId.create();
        TestNode.assertEquals((String)"get URI value", (String)U, (String)Node.createURI((String)U).getURI());
        TestNode.assertEquals((String)"get blank value", (Object)id, (Object)Node.createAnon((AnonId)id).getBlankNodeId());
        TestNode.assertEquals((String)"get literal value", (Object)L, (Object)Node.createLiteral((LiteralLabel)L).getLiteral());
        TestNode.assertEquals((String)"get variable name", (String)N, (String)Node.createVariable((String)N).getName());
    }

    public void testFailingLabels() {
        Node u = Node.createURI((String)U);
        Node b = Node.createAnon();
        Node l = Node.createLiteral((LiteralLabel)L);
        Node v = Node.createVariable((String)N);
        Node a = Node.ANY;
        this.testGetURIFails(a);
        this.testGetURIFails(b);
        this.testGetURIFails(l);
        this.testGetURIFails(v);
        this.testGetLiteralFails(a);
        this.testGetLiteralFails(u);
        this.testGetLiteralFails(b);
        this.testGetLiteralFails(v);
        this.testGetNameFails(a);
        this.testGetNameFails(u);
        this.testGetNameFails(b);
        this.testGetNameFails(l);
        this.testGetBlankNodeIdFails(a);
        this.testGetBlankNodeIdFails(u);
        this.testGetBlankNodeIdFails(l);
        this.testGetBlankNodeIdFails(v);
    }

    public void testGetBlankNodeIdFails(Node n) {
        try {
            n.getBlankNodeId();
            TestNode.fail((String)(n.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetURIFails(Node n) {
        try {
            n.getURI();
            TestNode.fail((String)(n.getClass() + " should fail getURI()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetNameFails(Node n) {
        try {
            n.getName();
            TestNode.fail((String)(n.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetLiteralFails(Node n) {
        try {
            n.getLiteral();
            TestNode.fail((String)(n.getClass() + " should fail getLiteral()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetBlankNodeLabelString() {
        Node n = Node.createAnon();
        TestNode.assertEquals((String)n.getBlankNodeId().getLabelString(), (String)n.getBlankNodeLabel());
    }

    public void testVariableSupport() {
        TestNode.assertEquals((Object)Node_Variable.variable((String)"xxx"), (Object)Node_Variable.variable((String)"xxx"));
        TestNode.assertDiffer(Node_Variable.variable((String)"xxx"), Node_Variable.variable((String)"yyy"));
        TestNode.assertEquals((Object)Node_Variable.variable((String)"aaa"), (Object)Node_Variable.variable((String)"aaa"));
        TestNode.assertDiffer(Node_Variable.variable((String)"aaa"), Node_Variable.variable((String)"yyy"));
    }

    public void testCache() {
        TestNode.assertEquals((Object)Node_Variable.variable((String)"xxx"), (Object)Node_Variable.variable((String)"xxx"));
        TestNode.assertTrue((String)"remembers URI", (Node.createURI((String)U) == Node.createURI((String)U) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers literal", (Node.createLiteral((LiteralLabel)L) == Node.createLiteral((LiteralLabel)L) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers hyphens", (Node.createAnon((AnonId)A) == Node.createAnon((AnonId)A) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers variables", (Node.createVariable((String)N) == Node.createVariable((String)N) ? 1 : 0) != 0);
        TestNode.assertFalse((String)"is not confused", (Node.createVariable((String)N) == Node.createURI((String)N) ? 1 : 0) != 0);
    }

    public void testCreateBadString() {
        try {
            NodeCreateUtils.create(null);
            TestNode.fail((String)"must catch null argument");
        }
        catch (NullPointerException e) {
        }
        catch (JenaException e) {
            // empty catch block
        }
        try {
            NodeCreateUtils.create("");
            TestNode.fail((String)"must catch empty argument");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testCreateAnon() {
        String idA = "_xxx";
        String idB = "_yyy";
        Node a = NodeCreateUtils.create(idA);
        Node b = NodeCreateUtils.create(idB);
        TestNode.assertTrue((String)"both must be bnodes", (a.isBlank() && b.isBlank() ? 1 : 0) != 0);
        TestNode.assertEquals((Object)new AnonId(idA), (Object)a.getBlankNodeId());
        TestNode.assertEquals((Object)new AnonId(idB), (Object)b.getBlankNodeId());
    }

    public void testCreateVariable() {
        String V = "wobbly";
        Node v = NodeCreateUtils.create("?" + V);
        TestNode.assertTrue((String)"must be a variable", (boolean)v.isVariable());
        TestNode.assertEquals((String)"name must be correct", (String)V, (String)v.getName());
    }

    public void testCreateANY() {
        TestNode.assertEquals((String)"?? must denote ANY", (Object)Node.ANY, (Object)NodeCreateUtils.create("??"));
    }

    public void testCreatePlainLiteralSingleQuotes() {
        Node n = NodeCreateUtils.create("'xxx'");
        TestNode.assertEquals((String)"xxx", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"", (String)n.getLiteralLanguage());
        TestNode.assertEquals(null, (String)n.getLiteralDatatypeURI());
    }

    public void testCreatePlainLiteralDoubleQuotes() {
        Node n = NodeCreateUtils.create("\"xxx\"");
        TestNode.assertEquals((String)"xxx", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"", (String)n.getLiteralLanguage());
        TestNode.assertEquals(null, (String)n.getLiteralDatatypeURI());
    }

    public void testCreateLiteralBackslashEscape() {
        this.testStringConversion("xx\\x", "'xx\\\\x'");
        this.testStringConversion("xx\\x\\y", "'xx\\\\x\\\\y'");
        this.testStringConversion("\\xyz\\", "'\\\\xyz\\\\'");
    }

    public void testCreateLiteralQuoteEscapes() {
        this.testStringConversion("x'y", "'x\\'y'");
        this.testStringConversion("x\"y", "'x\\\"y'");
        this.testStringConversion("x'y\"z", "'x\\'y\\\"z'");
    }

    public void testCreateLiteralOtherEscapes() {
        this.testStringConversion(" ", "'\\s'");
        this.testStringConversion("\t", "'\\t'");
        this.testStringConversion("\n", "'\\n'");
    }

    protected void testStringConversion(String wanted, String template) {
        Node n = NodeCreateUtils.create(template);
        TestNode.assertEquals((String)wanted, (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"", (String)n.getLiteralLanguage());
        TestNode.assertEquals(null, (String)n.getLiteralDatatypeURI());
    }

    public void testCreateLanguagedLiteralEN1() {
        Node n = NodeCreateUtils.create("'chat'en-UK");
        TestNode.assertEquals((String)"chat", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"en-UK", (String)n.getLiteralLanguage());
        TestNode.assertEquals(null, (String)n.getLiteralDatatypeURI());
    }

    public void testCreateLanguagedLiteralEN2() {
        Node n1 = NodeCreateUtils.create("'chat'en-UK");
        Node n2 = NodeCreateUtils.create("'chat'EN-UK");
        TestNode.assertTrue((boolean)n1.sameValueAs((Object)n2));
        TestNode.assertFalse((boolean)n1.equals((Object)n2));
    }

    public void testCreateLanguagedLiteralXY() {
        Node n = NodeCreateUtils.create("\"chat\"xy-AB");
        TestNode.assertEquals((String)"chat", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"xy-AB", (String)n.getLiteralLanguage());
        TestNode.assertEquals(null, (String)n.getLiteralDatatypeURI());
    }

    public void testCreateTypedLiteralInteger() {
        Node n = NodeCreateUtils.create("'42'xsd:integer");
        TestNode.assertEquals((String)"42", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"", (String)n.getLiteralLanguage());
        TestNode.assertEquals((String)this.expand("xsd:integer"), (String)n.getLiteralDatatypeURI());
    }

    public void testCreateTypedLiteralBoolean() {
        Node n = NodeCreateUtils.create("\"true\"xsd:boolean");
        TestNode.assertEquals((String)"true", (String)n.getLiteralLexicalForm());
        TestNode.assertEquals((String)"", (String)n.getLiteralLanguage());
        TestNode.assertEquals((String)this.expand("xsd:boolean"), (String)n.getLiteralDatatypeURI());
    }

    public void testGetPlainLiteralLexicalForm() {
        Node n = NodeCreateUtils.create("'stuff'");
        TestNode.assertEquals((String)"stuff", (String)n.getLiteralLexicalForm());
    }

    public void testGetNumericLiteralLexicalForm() {
        Node n = NodeCreateUtils.create("17");
        TestNode.assertEquals((String)"17", (String)n.getLiteralLexicalForm());
    }

    public void testTypesExpandPrefix() {
        this.testTypeExpandsPrefix("rdf:spoo");
        this.testTypeExpandsPrefix("rdfs:bar");
        this.testTypeExpandsPrefix("owl:henry");
        this.testTypeExpandsPrefix("xsd:bool");
        this.testTypeExpandsPrefix("unknown:spoo");
    }

    private void testTypeExpandsPrefix(String type) {
        Node n = NodeCreateUtils.create("'stuff'" + type);
        String wanted = PrefixMapping.Extended.expandPrefix(type);
        TestNode.assertEquals((String)wanted, (String)n.getLiteralDatatypeURI());
    }

    public void testCreateURI() {
        String uri = "http://www.electric-hedgehog.net/";
        this.testCreateURI(uri);
        this.testCreateURI("rdf:trinket", "http://www.w3.org/1999/02/22-rdf-syntax-ns#trinket");
        this.testCreateURI("rdfs:device", "http://www.w3.org/2000/01/rdf-schema#device");
        this.testCreateURI("dc:creator", DC.getURI() + "creator");
        this.testCreateURI("rss:something", RSS.getURI() + "something");
        this.testCreateURI("vcard:TITLE", VCARD.getURI() + "TITLE");
        this.testCreateURI("owl:wol", OWL.NAMESPACE + "wol");
    }

    public void testCreateURIOtherMap() {
        String myNS = "eh:foo/bar#";
        String suffix = "something";
        PrefixMapping mine = PrefixMapping.Factory.create().setNsPrefix("mine", myNS);
        Node n = NodeCreateUtils.create(mine, "mine:" + suffix);
        TestNode.assertEquals((String)(myNS + suffix), (String)n.getURI());
    }

    private void testCreateURI(String inOut) {
        this.testCreateURI(inOut, inOut);
    }

    private void testCreateURI(String in, String wanted) {
        String got = NodeCreateUtils.create(in).getURI();
        if (!wanted.equals(got)) {
            if (in.equals(wanted)) {
                TestNode.fail((String)("should preserve " + in));
            } else {
                TestNode.fail((String)("should translate " + in + " to " + wanted + " not " + got));
            }
        }
    }

    public void testCreatePrefixed() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        NodeCreateUtils.create(pm, "xyz");
    }

    public void testToStringWithPrefixMapping() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        String prefix = "spoo";
        String ns = "abc:def/ghi#";
        pm.setNsPrefix(prefix, ns);
        String suffix = "bamboozle";
        TestNode.assertEquals((String)(prefix + ":" + suffix), (String)NodeCreateUtils.create(ns + suffix).toString(pm));
    }

    public void testNodeHelp() {
        TestNode.assertTrue((String)"node() making URIs", (boolean)TestNode.node("hello").isURI());
        TestNode.assertTrue((String)"node() making literals", (boolean)TestNode.node("123").isLiteral());
        TestNode.assertTrue((String)"node() making literals", (boolean)TestNode.node("'hello'").isLiteral());
        TestNode.assertTrue((String)"node() making hyphens", (boolean)TestNode.node("_x").isBlank());
        TestNode.assertTrue((String)"node() making variables", (boolean)TestNode.node("?x").isVariable());
    }

    public void testVisitorPatternNode() {
        NodeVisitor returnNode = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                return it;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                return it;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                return it;
            }

            public Object visitURI(Node_URI it, String uri) {
                return it;
            }

            public Object visitVariable(Node_Variable it, String name) {
                return it;
            }
        };
        this.testVisitorPatternNode("sortOfURI", returnNode);
        this.testVisitorPatternNode("?variable", returnNode);
        this.testVisitorPatternNode("_anon", returnNode);
        this.testVisitorPatternNode("11", returnNode);
        this.testVisitorPatternNode("??", returnNode);
    }

    private void testVisitorPatternNode(String ns, NodeVisitor v) {
        Node n = TestNode.node(ns);
        TestNode.assertEquals((Object)n, (Object)n.visitWith(v));
    }

    private void visitExamples(NodeVisitor nv) {
        TestNode.node("sortOfURI").visitWith(nv);
        TestNode.node("?variableI").visitWith(nv);
        TestNode.node("_anon").visitWith(nv);
        TestNode.node("11").visitWith(nv);
        TestNode.node("??").visitWith(nv);
    }

    public void testVisitorPatternValue() {
        NodeVisitor checkValue = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                return null;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                Assert.assertTrue((it.getBlankNodeId() == id ? 1 : 0) != 0);
                return null;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                Assert.assertTrue((it.getLiteral() == lit ? 1 : 0) != 0);
                return null;
            }

            public Object visitURI(Node_URI it, String uri) {
                Assert.assertTrue((it.getURI() == uri ? 1 : 0) != 0);
                return null;
            }

            public Object visitVariable(Node_Variable it, String name) {
                Assert.assertEquals((String)it.getName(), (String)name);
                return null;
            }
        };
        this.visitExamples(checkValue);
    }

    public void testVisitorPatternCalled() {
        final String[] strings = new String[]{""};
        NodeVisitor checkCalled = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                strings[0] = strings[0] + " any";
                return null;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                strings[0] = strings[0] + " blank";
                return null;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                strings[0] = strings[0] + " literal";
                return null;
            }

            public Object visitURI(Node_URI it, String uri) {
                strings[0] = strings[0] + " uri";
                return null;
            }

            public Object visitVariable(Node_Variable it, String name) {
                strings[0] = strings[0] + " variable";
                return null;
            }
        };
        String desired = " uri variable blank literal any";
        this.visitExamples(checkCalled);
        TestNode.assertEquals((String)"all vists must have been made", (String)desired, (String)strings[0]);
    }

    public void testSimpleMatches() {
        TestNode.assertTrue((boolean)NodeCreateUtils.create("S").matches(NodeCreateUtils.create("S")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("S").matches(NodeCreateUtils.create("T")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("S").matches(null));
        TestNode.assertTrue((boolean)NodeCreateUtils.create("_X").matches(NodeCreateUtils.create("_X")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("_X").matches(NodeCreateUtils.create("_Y")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("_X").matches(null));
        TestNode.assertTrue((boolean)NodeCreateUtils.create("10").matches(NodeCreateUtils.create("10")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("10").matches(NodeCreateUtils.create("11")));
        TestNode.assertFalse((String)"", (boolean)NodeCreateUtils.create("10").matches(null));
        TestNode.assertTrue((boolean)Node.ANY.matches(NodeCreateUtils.create("S")));
        TestNode.assertTrue((boolean)Node.ANY.matches(NodeCreateUtils.create("_X")));
        TestNode.assertTrue((boolean)Node.ANY.matches(NodeCreateUtils.create("10")));
        TestNode.assertFalse((String)"", (boolean)Node.ANY.matches(null));
    }

    public void testDataMatches() {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dt1 = tm.getTypeByValue((Object)new Integer(10));
        RDFDatatype dt2 = tm.getTypeByValue((Object)new Short(10));
        Node a = Node.createLiteral((String)"10", (String)"", (RDFDatatype)dt1);
        Node b = Node.createLiteral((String)"10", (String)"", (RDFDatatype)dt2);
        TestNode.assertDiffer("types must make a difference", a, b);
        TestNode.assertTrue((String)"A and B must express the same value", (boolean)a.sameValueAs((Object)b));
        TestNode.assertTrue((String)"matching literals must respect sameValueAs", (boolean)a.matches(b));
    }

    public void testLiteralToString() {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dtInt = tm.getTypeByValue((Object)new Integer(10));
        Node plain = Node.createLiteral((String)"rhubarb", (String)"", (boolean)false);
        Node english = Node.createLiteral((String)"eccentric", (String)"en_UK", (boolean)false);
        Node typed = Node.createLiteral((String)"10", (String)"", (RDFDatatype)dtInt);
        TestNode.assertEquals((String)"\"rhubarb\"", (String)plain.toString());
        TestNode.assertEquals((String)"rhubarb", (String)plain.toString(false));
        TestNode.assertEquals((String)"\"eccentric\"@en_UK", (String)english.toString());
        TestNode.assertEquals((String)"10^^http://www.w3.org/2001/XMLSchema#int", (String)typed.toString(false));
    }

    public void testGetIndexingValueURI() {
        Node u = NodeCreateUtils.create("eh:/telephone");
        TestNode.assertSame((Object)u, (Object)u.getIndexingValue());
    }

    public void testGetIndexingValueBlank() {
        Node b = NodeCreateUtils.create("_television");
        TestNode.assertSame((Object)b, (Object)b.getIndexingValue());
    }

    public void testGetIndexingValuePlainString() {
        this.testIndexingValueLiteral(NodeCreateUtils.create("'literally'"));
    }

    public void testGetIndexingValueLanguagedString() {
        this.testIndexingValueLiteral(NodeCreateUtils.create("'chat'fr"));
    }

    public void testGetIndexingValueXSDString() {
        this.testIndexingValueLiteral(NodeCreateUtils.create("'string'xsd:string"));
    }

    private void testIndexingValueLiteral(Node s) {
        TestNode.assertEquals((Object)s.getLiteral().getIndexingValue(), (Object)s.getIndexingValue());
    }

    public void testGetLiteralValuePlainString() {
        Node s = NodeCreateUtils.create("'aString'");
        TestNode.assertSame((Object)s.getLiteral().getValue(), (Object)s.getLiteralValue());
    }

    public void testGetLiteralDatatypeNull() {
        TestNode.assertEquals(null, (Object)NodeCreateUtils.create("'plain'").getLiteralDatatype());
    }

    public void testLiteralIsXML() {
        TestNode.assertFalse((boolean)NodeCreateUtils.create("'notXML'").getLiteralIsXML());
        TestNode.assertFalse((boolean)NodeCreateUtils.create("17").getLiteralIsXML());
        TestNode.assertFalse((boolean)NodeCreateUtils.create("'joke'xsd:Joke").getLiteralIsXML());
        TestNode.assertTrue((boolean)Node.createLiteral((String)"lit", (String)"lang", (boolean)true).getLiteralIsXML());
        TestNode.assertFalse((boolean)Node.createLiteral((String)"lit", (String)"lang", (boolean)false).getLiteralIsXML());
    }

    public void testConcrete() {
        TestNode.assertTrue((boolean)NodeCreateUtils.create("S").isConcrete());
        TestNode.assertTrue((boolean)NodeCreateUtils.create("_P").isConcrete());
        TestNode.assertTrue((boolean)NodeCreateUtils.create("11").isConcrete());
        TestNode.assertTrue((boolean)NodeCreateUtils.create("'hello'").isConcrete());
        TestNode.assertFalse((boolean)NodeCreateUtils.create("??").isConcrete());
        TestNode.assertFalse((boolean)NodeCreateUtils.create("?x").isConcrete());
    }

    public void testNamespace() {
        for (int i = 0; i < someURIs.length; ++i) {
            String uri = someURIs[i];
            int split = Util.splitNamespace((String)uri);
            Node n = NodeCreateUtils.create(uri);
            TestNode.assertEquals((String)"check namespace", (String)uri.substring(0, split), (String)n.getNameSpace());
            TestNode.assertEquals((String)"check localname", (String)uri.substring(split), (String)n.getLocalName());
        }
    }

    public void testHasURI() {
        int i;
        for (i = 0; i < someURIs.length; ++i) {
            this.testHasURI(someURIs[i]);
        }
        for (i = 0; i < someNodes.length; ++i) {
            this.testHasURI(someNodes[i]);
        }
    }

    protected void testHasURI(String uri) {
        Node n = NodeCreateUtils.create(uri);
        TestNode.assertTrue((String)uri, (!n.isURI() || n.hasURI(uri) ? 1 : 0) != 0);
        TestNode.assertFalse((String)uri, (boolean)n.hasURI(uri + "x"));
    }

    private String expand(String s) {
        return PrefixMapping.Extended.expandPrefix(s);
    }
}

