/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestRegexpTrees
extends GraphTestBase {
    protected Object[][] equalities = new Object[][]{{new EndOfLine(), "EOL"}, {new EndOfLine(), "EOL"}, {new StartOfLine(), "SOL"}, {new StartOfLine(), "SOL"}, {new AnySingle(), "ANY"}, {new AnySingle(), "ANY"}, {new Paren((RegexpTree)new AnySingle()), "(ANY)"}, {new Paren((RegexpTree)new EndOfLine()), "(EOL)"}, {Text.create((String)"hello"), "hello"}, {Text.create((String)"goodbye"), "goodbye"}, {new AnyOf("abcde"), "any[abcde]"}, {new AnyOf("defgh"), "any[defgh]"}, {new NoneOf("pqrst"), "none[pqrst]"}, {new NoneOf("12345"), "none[12345]"}, {new BackReference(1), "back(1)"}, {new BackReference(2), "back(2)"}};

    public TestRegexpTrees(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRegexpTrees.class);
    }

    public void testEqualities() {
        for (int i = 0; i < this.equalities.length; ++i) {
            for (int j = 0; j < this.equalities.length; ++j) {
                Object[] A = this.equalities[i];
                Object[] B = this.equalities[j];
                boolean equal = A[1].equals(B[1]);
                if (A[0].equals(B[0]) == equal) continue;
                TestRegexpTrees.fail((String)(A[0] + " should be " + (equal ? "equal to " : "different from ") + B[0]));
            }
        }
    }

    public void testConstantsDefinition() {
        TestRegexpTrees.assertEquals((Object)RegexpTree.EOL, (Object)new EndOfLine());
        TestRegexpTrees.assertEquals((Object)RegexpTree.SOL, (Object)new StartOfLine());
        TestRegexpTrees.assertEquals((Object)RegexpTree.ANY, (Object)new AnySingle());
    }

    public void testExtractOperandFromOneOrMore() {
        this.testExtractFromOneOrMore(RegexpTree.EOL);
        this.testExtractFromOneOrMore(RegexpTree.SOL);
        this.testExtractFromOneOrMore(RegexpTree.ANY);
    }

    public void testExtractOperandFromZeroOrMore() {
        this.testExtractFromZeroOrMore(RegexpTree.EOL);
        this.testExtractFromZeroOrMore(RegexpTree.SOL);
        this.testExtractFromZeroOrMore(RegexpTree.ANY);
    }

    public void testExtractOperandFromOptional() {
        this.testExtractFromOptional(RegexpTree.EOL);
        this.testExtractFromOptional(RegexpTree.SOL);
        this.testExtractFromOptional(RegexpTree.ANY);
    }

    public void testLiteralContents() {
        TestRegexpTrees.assertEquals((String)"hello", (String)Text.create((String)"hello").getString());
    }

    public void testParenOperand() {
        TestRegexpTrees.assertSame((Object)RegexpTree.EOL, (Object)new Paren(RegexpTree.EOL).getOperand());
    }

    public void testParenIndex() {
        TestRegexpTrees.assertEquals((int)0, (int)new Paren(RegexpTree.EOL).getIndex());
        TestRegexpTrees.assertEquals((int)1, (int)new Paren(RegexpTree.EOL, 1).getIndex());
        TestRegexpTrees.assertEquals((int)17, (int)new Paren(RegexpTree.NON, 17).getIndex());
    }

    public void testBackReference() {
        TestRegexpTrees.assertEquals((int)2, (int)new BackReference(2).getIndex());
    }

    protected void testExtractFromOneOrMore(RegexpTree operand) {
        TestRegexpTrees.assertSame((Object)operand, (Object)new OneOrMore(operand).getOperand());
    }

    protected void testExtractFromZeroOrMore(RegexpTree operand) {
        TestRegexpTrees.assertSame((Object)operand, (Object)new ZeroOrMore(operand).getOperand());
    }

    protected void testExtractFromOptional(RegexpTree operand) {
        TestRegexpTrees.assertSame((Object)operand, (Object)new Optional(operand).getOperand());
    }
}

