/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Iterator;

abstract class BaseList {
    protected int elementCount;

    BaseList() {
    }

    abstract Object get(int var1);

    abstract Object remove(int var1);

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32 + this.elementCount * 3);
        stringBuffer.append("List : size=");
        stringBuffer.append(this.elementCount);
        stringBuffer.append(' ');
        stringBuffer.append('{');
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new BaseListIterator();
    }

    private class BaseListIterator
    implements Iterator {
        int counter = 0;
        boolean removed;

        private BaseListIterator() {
        }

        public boolean hasNext() {
            return this.counter < BaseList.this.elementCount;
        }

        public Object next() {
            if (this.counter < BaseList.this.elementCount) {
                this.removed = false;
                Object object = BaseList.this.get(this.counter);
                ++this.counter;
                return object;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.removed) {
                throw new NoSuchElementException("Iterator");
            }
            this.removed = true;
            if (this.counter != 0) {
                BaseList.this.remove(this.counter - 1);
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

