/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModGraphStore;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;
import java.util.List;

public class update
extends CmdARQ {
    ModGraphStore modGraphStore = new ModGraphStore();
    ArgDecl updateArg = new ArgDecl(true, "--update");
    ArgDecl dumpArg = new ArgDecl(false, "--dump");
    List requestFiles = null;
    boolean dump = false;

    public static void main(String[] argv) {
        new update(argv).main();
    }

    protected update(String[] argv) {
        super(argv);
        super.addModule(this.modGraphStore);
        super.add(this.updateArg, "--update=FILE", "Update commands to execute");
        super.add(this.dumpArg, "--dump", "Dump the resulting graph store");
    }

    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(this.updateArg);
        this.dump = this.contains(this.dumpArg);
        super.processModulesAndArgs();
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    protected void exec() {
        GraphStore graphStore = this.modGraphStore.getGraphStore();
        if (graphStore.getDefaultGraph() == null) {
            graphStore.setDefaultGraph(ModelFactory.createDefaultModel().getGraph());
        }
        if (this.requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        Iterator iter = this.requestFiles.iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            this.execOneFile(filename, graphStore);
        }
        iter = super.getPositional().iterator();
        while (iter.hasNext()) {
            String requestString = (String)iter.next();
            this.execOne(requestString, graphStore);
        }
        if (this.dump) {
            IndentedWriter out = IndentedWriter.stdout;
            SSE.write((Dataset)graphStore.toDataset());
            out.flush();
        }
    }

    private void execOneFile(String filename, GraphStore store) {
        UpdateRequest req = UpdateFactory.read((String)filename);
        store.execute(req);
    }

    private void execOne(String requestString, GraphStore store) {
        UpdateRequest req = UpdateFactory.create((String)requestString);
        store.execute(req);
        store.close();
    }
}

