/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class RDQLQueryPrintUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static int bNodeCounter = 0;
    static Map bNodeStrings = new HashMap();
    static PrefixMapping prefixes = PrefixMapping.Factory.create().setNsPrefixes(PrefixMapping.Standard).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    static final int indent = 2;

    public static void print(PrintWriter pw, ExprRDQL expr) {
        pw.println(expr.asPrefixString());
    }

    public static String asInfixString1(ExprRDQL expr, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(symbol);
        sb.append(" ");
        sb.append(expr.asInfixString());
        sb.append(")");
        return sb.toString();
    }

    public static String asInfixString2(ExprRDQL left, ExprRDQL right, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        sb.append(left.asInfixString());
        sb.append(" ");
        sb.append(symbol);
        sb.append(" ");
        sb.append(right.asInfixString());
        sb.append(" )");
        return sb.toString();
    }

    public static String asPrefixString(ExprRDQL left, ExprRDQL right, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(printOpName ? opName : symbol);
        sb.append(" ");
        sb.append(left.asPrefixString());
        if (right != null) {
            sb.append(" ");
            sb.append(right.asPrefixString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static void format(IndentedWriter w, ExprRDQL left, ExprRDQL right, String opName, String symbol) {
        w.print("( ");
        if (right == null) {
            w.print(symbol);
            left.format(w);
        } else {
            left.format(w);
            w.print(" ");
            w.print(symbol);
            w.print(" ");
            right.format(w);
        }
        w.print(" )");
    }
}

