/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.update.GraphStore;

public abstract class UpdateEngineBase
implements UpdateEngine {
    protected final GraphStore graphStore;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineBase(GraphStore graphStore, Binding inputBinding, Context context) {
        this.graphStore = graphStore;
        this.inputBinding = inputBinding;
        this.context = UpdateEngineBase.setupContext(context, graphStore);
    }

    private static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context;
    }
}

