/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class ObjectNameSpec {
    static final String NAME_DOMAIN = "com.hazelcast:";
    private String type = null;
    private String cluster = null;
    private String name = null;

    public ObjectNameSpec() {
    }

    public ObjectNameSpec(String type, String name) {
        this.type = this.clean(type);
        this.name = this.clean(name);
    }

    public ObjectNameSpec(String name) {
        this.cluster = this.clean(name);
    }

    private String clean(String name) {
        if (name == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[:\",=*?]");
        Matcher matcher = pattern.matcher(name);
        return matcher.find() ? ObjectName.quote(name) : name;
    }

    public ObjectNameSpec getNested(String type) {
        if (this.cluster == null) {
            throw new IllegalStateException("Not clustered object");
        }
        ObjectNameSpec result = new ObjectNameSpec(this.cluster);
        result.type = this.clean(type);
        return result;
    }

    public ObjectNameSpec getNested(String type, String name) {
        if (this.cluster == null) {
            throw new IllegalStateException("Not clustered object");
        }
        ObjectNameSpec result = new ObjectNameSpec(this.cluster);
        result.type = this.clean(type);
        result.name = this.clean(name);
        return result;
    }

    public ObjectName buildObjectName() throws Exception {
        StringBuilder sb = new StringBuilder(NAME_DOMAIN);
        if (this.type != null) {
            sb.append("type=").append(this.type);
        }
        if (this.cluster != null) {
            if (this.type != null) {
                sb.append(',');
            }
            sb.append("Cluster=").append(this.cluster);
        }
        if (this.name != null) {
            if (this.type != null || this.cluster != null) {
                sb.append(',');
            }
            sb.append("name=").append(this.name);
        }
        return new ObjectName(sb.toString());
    }

    public ObjectName buildObjectName(String type, String name) throws Exception {
        StringBuilder sb = new StringBuilder(NAME_DOMAIN);
        if (type != null) {
            sb.append("type=").append(this.clean(type));
        }
        if (name != null) {
            if (type != null || this.cluster != null) {
                sb.append(',');
            }
            sb.append("name=").append(this.clean(name));
        }
        return new ObjectName(sb.toString());
    }
}

