/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.partition.MemberGroup;
import com.hazelcast.impl.partition.MemberGroupFactory;
import com.hazelcast.impl.partition.MigrationRequestTask;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.impl.partition.PartitionStateGenerator;
import com.hazelcast.impl.partition.SingleMemberGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartitionStateGeneratorImpl
implements PartitionStateGenerator {
    private static final ILogger logger = Logger.getLogger(PartitionStateGenerator.class.getName());
    private static final float RANGE_CHECK_RATIO = 1.1f;
    private static final int MAX_RETRY_COUNT = 3;
    private static final int AGGRESSIVE_RETRY_THRESHOLD = 1;
    private static final int AGGRESSIVE_INDEX_THRESHOLD = 3;
    private static final int MIN_AVG_OWNER_DIFF = 3;
    private final MemberGroupFactory memberGroupFactory;

    public PartitionStateGeneratorImpl(MemberGroupFactory memberGroupFactory) {
        this.memberGroupFactory = memberGroupFactory;
    }

    @Override
    public PartitionInfo[] initialize(Collection<MemberImpl> members, int partitionCount) {
        LinkedList<NodeGroup> groups = this.createNodeGroups(this.memberGroupFactory.createMemberGroups(members));
        if (groups.size() == 0) {
            return null;
        }
        return this.arrange(groups, partitionCount, new EmptyStateInitializer());
    }

    @Override
    public PartitionInfo[] reArrange(PartitionInfo[] currentState, Collection<MemberImpl> members, int partitionCount, List<MigrationRequestTask> lostPartitionTasksList, List<MigrationRequestTask> immediateTasksList, List<MigrationRequestTask> scheduledTasksList) {
        LinkedList<NodeGroup> groups = this.createNodeGroups(this.memberGroupFactory.createMemberGroups(members));
        if (groups.size() == 0) {
            return currentState;
        }
        PartitionInfo[] newState = this.arrange(groups, partitionCount, new CopyStateInitializer(currentState));
        this.finalizeArrangement(currentState, newState, lostPartitionTasksList, immediateTasksList, scheduledTasksList);
        return newState;
    }

    private PartitionInfo[] arrange(LinkedList<NodeGroup> groups, int partitionCount, StateInitializer stateInitializer) {
        PartitionInfo[] state = new PartitionInfo[partitionCount];
        stateInitializer.initialize(state);
        TestResult result = null;
        int tryCount = 0;
        while (tryCount < 3 && result != TestResult.PASS) {
            boolean aggressive = tryCount >= 1;
            this.tryArrange(state, groups, partitionCount, aggressive);
            result = this.testArrangement(state, groups, partitionCount);
            if (result == TestResult.FAIL) {
                logger.log(Level.WARNING, "Error detected on partition arrangement! Try-count: " + tryCount);
                stateInitializer.initialize(state);
                continue;
            }
            if (result != TestResult.RETRY) continue;
            logger.log(Level.INFO, "Re-trying partition arrangement.. Count: " + ++tryCount);
        }
        if (result == TestResult.FAIL) {
            logger.log(Level.SEVERE, "Failed to arrange partitions !!!");
        }
        return state;
    }

    private void finalizeArrangement(PartitionInfo[] currentState, PartitionInfo[] newState, List<MigrationRequestTask> lostPartitionTasksList, List<MigrationRequestTask> immediateTasksList, List<MigrationRequestTask> scheduledTasksList) {
        int partitionCount = currentState.length;
        LinkedList<MigrationRequestTask> partitionMigrationTasks = new LinkedList<MigrationRequestTask>();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionInfo currentPartition = currentState[partitionId];
            PartitionInfo newPartition = newState[partitionId];
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                Address currentOwner = currentPartition.getReplicaAddress(replicaIndex);
                Address newOwner = newPartition.getReplicaAddress(replicaIndex);
                MigrationRequestTask migrationRequestTask = null;
                if (currentOwner != null && newOwner != null && !currentOwner.equals(newOwner)) {
                    migrationRequestTask = new MigrationRequestTask(partitionId, currentOwner, newOwner, replicaIndex, true);
                } else if (currentOwner == null && newOwner != null) {
                    currentOwner = currentPartition.getOwner();
                    boolean selfCopy = false;
                    ListIterator iter = partitionMigrationTasks.listIterator(partitionMigrationTasks.size());
                    while (iter.hasPrevious()) {
                        MigrationRequestTask task = (MigrationRequestTask)iter.previous();
                        if (!task.isMigration() || !newOwner.equals(task.getFromAddress())) continue;
                        selfCopy = true;
                        task.setSelfCopyReplicaIndex(replicaIndex);
                        break;
                    }
                    if (!selfCopy) {
                        migrationRequestTask = new MigrationRequestTask(partitionId, currentOwner, newOwner, replicaIndex, false);
                    }
                } else if (currentOwner != null && newOwner == null) {
                    immediateTasksList.add(new MigrationRequestTask(partitionId, currentOwner, null, replicaIndex, false));
                }
                if (migrationRequestTask == null) continue;
                partitionMigrationTasks.add(migrationRequestTask);
                if (replicaIndex == 0 && currentOwner == null) {
                    lostPartitionTasksList.add(migrationRequestTask);
                    continue;
                }
                if (replicaIndex == 0 && currentOwner != null && currentOwner.equals(newPartition.getReplicaAddress(1))) {
                    immediateTasksList.add(migrationRequestTask);
                    continue;
                }
                if (replicaIndex == 1 && currentPartition.getReplicaAddress(1) == null) {
                    immediateTasksList.add(migrationRequestTask);
                    continue;
                }
                scheduledTasksList.add(migrationRequestTask);
            }
            partitionMigrationTasks.clear();
        }
        this.arrangeScheduledTasks(scheduledTasksList);
    }

    private void arrangeScheduledTasks(List<MigrationRequestTask> scheduledTasksList) {
        Collections.shuffle(scheduledTasksList);
        Collections.sort(scheduledTasksList, new Comparator<MigrationRequestTask>(){

            @Override
            public int compare(MigrationRequestTask t1, MigrationRequestTask t2) {
                if (t1.getReplicaIndex() == t2.getReplicaIndex()) {
                    return 0;
                }
                if (t1.getReplicaIndex() <= 1 && t2.getReplicaIndex() <= 1) {
                    return 0;
                }
                if (t1.getReplicaIndex() <= 1) {
                    return -1;
                }
                if (t2.getReplicaIndex() <= 1) {
                    return 1;
                }
                return t1.getReplicaIndex() > t2.getReplicaIndex() ? 1 : -1;
            }
        });
    }

    private void tryArrange(PartitionInfo[] state, LinkedList<NodeGroup> groups, int partitionCount, boolean aggressive) {
        int groupSize = groups.size();
        int replicaCount = Math.min(groupSize, 7);
        int avgPartitionPerGroup = partitionCount / groupSize;
        this.initializeGroupPartitions(state, groups, replicaCount, aggressive);
        for (int index = 0; index < replicaCount; ++index) {
            LinkedList<Integer> freePartitions = this.getUnownedPartitions(state, index);
            LinkedList<NodeGroup> underLoadedGroups = new LinkedList<NodeGroup>();
            LinkedList<NodeGroup> overLoadedGroups = new LinkedList<NodeGroup>();
            int plusOneGroupCount = partitionCount - avgPartitionPerGroup * groupSize;
            for (NodeGroup nodeGroup : groups) {
                int size = nodeGroup.getPartitionCount(index);
                if (size < avgPartitionPerGroup) {
                    underLoadedGroups.add(nodeGroup);
                    continue;
                }
                if (size <= avgPartitionPerGroup) continue;
                overLoadedGroups.add(nodeGroup);
            }
            plusOneGroupCount = this.tryToDistributeUnownedPartitions(underLoadedGroups, freePartitions, avgPartitionPerGroup, index, plusOneGroupCount);
            if (!freePartitions.isEmpty()) {
                this.distributeUnownedPartitions(groups, freePartitions, index);
            }
            this.transferPartitionsBetweenGroups(underLoadedGroups, overLoadedGroups, index, avgPartitionPerGroup, plusOneGroupCount);
            this.updatePartitionState(state, groups, index);
        }
    }

    private void transferPartitionsBetweenGroups(Queue<NodeGroup> underLoadedGroups, Collection<NodeGroup> overLoadedGroups, int index, int avgPartitionPerGroup, int plusOneGroupCount) {
        int expectedPartitionCount;
        int maxPartitionPerGroup = avgPartitionPerGroup + 1;
        int maxTries = underLoadedGroups.size() * overLoadedGroups.size() * 10;
        int tries = 0;
        int n = expectedPartitionCount = plusOneGroupCount > 0 ? maxPartitionPerGroup : avgPartitionPerGroup;
        while (tries++ < maxTries && !underLoadedGroups.isEmpty()) {
            NodeGroup toGroup = underLoadedGroups.poll();
            Iterator<NodeGroup> overLoadedGroupsIter = overLoadedGroups.iterator();
            while (overLoadedGroupsIter.hasNext()) {
                NodeGroup fromGroup = overLoadedGroupsIter.next();
                Iterator<Integer> partitionsIter = fromGroup.getPartitionsIterator(index);
                while (partitionsIter.hasNext() && fromGroup.getPartitionCount(index) > expectedPartitionCount && toGroup.getPartitionCount(index) < expectedPartitionCount) {
                    Integer partitionId = partitionsIter.next();
                    if (!toGroup.addPartition(index, partitionId)) continue;
                    partitionsIter.remove();
                }
                int fromCount = fromGroup.getPartitionCount(index);
                if (plusOneGroupCount > 0 && fromCount == maxPartitionPerGroup && --plusOneGroupCount == 0) {
                    expectedPartitionCount = avgPartitionPerGroup;
                }
                if (fromCount <= expectedPartitionCount) {
                    overLoadedGroupsIter.remove();
                }
                int toCount = toGroup.getPartitionCount(index);
                if (plusOneGroupCount > 0 && toCount == maxPartitionPerGroup && --plusOneGroupCount == 0) {
                    expectedPartitionCount = avgPartitionPerGroup;
                }
                if (toCount < expectedPartitionCount) continue;
                break;
            }
            if (toGroup.getPartitionCount(index) >= avgPartitionPerGroup) continue;
            underLoadedGroups.offer(toGroup);
        }
    }

    private void updatePartitionState(PartitionInfo[] state, Collection<NodeGroup> groups, int index) {
        for (NodeGroup group : groups) {
            group.postProcessPartitionTable(index);
            for (Address address : group.getNodes()) {
                PartitionTable table = group.getPartitionTable(address);
                Set<Integer> set = table.getPartitions(index);
                for (Integer partitionId : set) {
                    state[partitionId].setReplicaAddress(index, address);
                }
            }
        }
    }

    private void distributeUnownedPartitions(Queue<NodeGroup> groups, Queue<Integer> freePartitions, int index) {
        int groupSize = groups.size();
        int maxTries = freePartitions.size() * groupSize * 10;
        int tries = 0;
        Integer partitionId = freePartitions.poll();
        while (partitionId != null && tries++ < maxTries) {
            NodeGroup group = groups.poll();
            if (group.addPartition(index, partitionId)) {
                partitionId = freePartitions.poll();
            }
            groups.offer(group);
        }
    }

    private int tryToDistributeUnownedPartitions(Queue<NodeGroup> underLoadedGroups, Queue<Integer> freePartitions, int avgPartitionPerGroup, int index, int plusOneGroupCount) {
        int maxPartitionPerGroup = avgPartitionPerGroup + 1;
        int maxTries = freePartitions.size() * underLoadedGroups.size();
        int tries = 0;
        while (tries++ < maxTries && !freePartitions.isEmpty() && !underLoadedGroups.isEmpty()) {
            Integer partitionId;
            NodeGroup group = underLoadedGroups.poll();
            int size = freePartitions.size();
            for (int i = 0; i < size && !group.addPartition(index, partitionId = freePartitions.poll()); ++i) {
                freePartitions.offer(partitionId);
            }
            int count = group.getPartitionCount(index);
            if (plusOneGroupCount > 0 && count == maxPartitionPerGroup) {
                if (--plusOneGroupCount != 0) continue;
                Iterator underLoaded = underLoadedGroups.iterator();
                while (underLoaded.hasNext()) {
                    if (((NodeGroup)underLoaded.next()).getPartitionCount(index) < avgPartitionPerGroup) continue;
                    underLoaded.remove();
                }
                continue;
            }
            if ((plusOneGroupCount <= 0 || count >= maxPartitionPerGroup) && count >= avgPartitionPerGroup) continue;
            underLoadedGroups.offer(group);
        }
        return plusOneGroupCount;
    }

    private LinkedList<Integer> getUnownedPartitions(PartitionInfo[] state, int index) {
        LinkedList<Integer> freePartitions = new LinkedList<Integer>();
        for (PartitionInfo partition : state) {
            if (partition.getReplicaAddress(index) != null) continue;
            freePartitions.add(partition.getPartitionId());
        }
        Collections.shuffle(freePartitions);
        return freePartitions;
    }

    private void initializeGroupPartitions(PartitionInfo[] state, LinkedList<NodeGroup> groups, int replicaCount, boolean aggressive) {
        for (NodeGroup nodeGroup : groups) {
            nodeGroup.resetPartitions();
        }
        for (PartitionInfo partition : state) {
            for (int index = 0; index < 7; ++index) {
                if (index >= replicaCount) {
                    partition.setReplicaAddress(index, null);
                    continue;
                }
                Address owner = partition.getReplicaAddress(index);
                boolean valid = false;
                if (owner != null) {
                    for (NodeGroup nodeGroup : groups) {
                        if (!nodeGroup.hasNode(owner)) continue;
                        if (!nodeGroup.ownPartition(owner, index, partition.getPartitionId())) break;
                        valid = true;
                        break;
                    }
                }
                if (!valid) {
                    partition.setReplicaAddress(index, null);
                    continue;
                }
                if (!valid || !aggressive || index >= 3) continue;
                for (int i = 3; i < replicaCount; ++i) {
                    partition.setReplicaAddress(i, null);
                }
            }
        }
    }

    private LinkedList<NodeGroup> createNodeGroups(Collection<MemberGroup> memberGroups) {
        LinkedList<NodeGroup> nodeGroups = new LinkedList<NodeGroup>();
        for (MemberGroup memberGroup : memberGroups) {
            NodeGroup nodeGroup;
            if (memberGroup.size() == 0) continue;
            if (memberGroup instanceof SingleMemberGroup || memberGroup.size() == 1) {
                nodeGroup = new SingleNodeGroup();
                nodeGroup.addNode(memberGroup.iterator().next().getAddress());
            } else {
                nodeGroup = new DefaultNodeGroup();
                Iterator<MemberImpl> iter = memberGroup.iterator();
                while (iter.hasNext()) {
                    nodeGroup.addNode(iter.next().getAddress());
                }
            }
            nodeGroups.add(nodeGroup);
        }
        return nodeGroups;
    }

    private TestResult testArrangement(PartitionInfo[] state, Collection<NodeGroup> groups, int partitionCount) {
        float ratio = 1.1f;
        int avgPartitionPerGroup = partitionCount / groups.size();
        int replicaCount = Math.min(groups.size(), 7);
        HashSet<Address> set = new HashSet<Address>();
        for (PartitionInfo p : state) {
            for (int i = 0; i < replicaCount; ++i) {
                Address owner = p.getReplicaAddress(i);
                if (owner == null) {
                    logger.log(Level.WARNING, "Partition-Arrangement-Test: Owner is null !!! => partition: " + p.getPartitionId() + " replica: " + i);
                    return TestResult.FAIL;
                }
                if (set.contains(owner)) {
                    logger.log(Level.WARNING, "Partition-Arrangement-Test: " + owner + " has owned multiple replicas of partition: " + p.getPartitionId() + " replica: " + i);
                    return TestResult.FAIL;
                }
                set.add(owner);
            }
            set.clear();
        }
        for (NodeGroup group : groups) {
            for (int i = 0; i < replicaCount; ++i) {
                int partitionCountOfGroup = group.getPartitionCount(i);
                if (Math.abs(partitionCountOfGroup - avgPartitionPerGroup) <= 3 || !((float)partitionCountOfGroup < (float)avgPartitionPerGroup / 1.1f) && !((float)partitionCountOfGroup > (float)avgPartitionPerGroup * 1.1f)) continue;
                logger.log(Level.FINEST, "Replica: " + i + ", PartitionCount: " + partitionCountOfGroup + ", AvgPartitionCount: " + avgPartitionPerGroup);
                return TestResult.RETRY;
            }
        }
        return TestResult.PASS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PartitionTable {
        final Set<Integer>[] partitions = new Set[7];

        private PartitionTable() {
        }

        Set<Integer> getPartitions(int index) {
            this.check(index);
            Set<Integer> set = this.partitions[index];
            if (set == null) {
                this.partitions[index] = set = new HashSet<Integer>();
            }
            return set;
        }

        boolean add(int index, Integer partitionId) {
            return this.getPartitions(index).add(partitionId);
        }

        boolean contains(int index, Integer partitionId) {
            return this.getPartitions(index).contains(partitionId);
        }

        boolean contains(Integer partitionId) {
            for (int i = 0; i < this.partitions.length; ++i) {
                Set<Integer> set = this.partitions[i];
                if (set == null || !set.contains(partitionId)) continue;
                return true;
            }
            return false;
        }

        boolean remove(int index, Integer partitionId) {
            return this.getPartitions(index).remove(partitionId);
        }

        int size(int index) {
            return this.getPartitions(index).size();
        }

        void reset() {
            for (int i = 0; i < this.partitions.length; ++i) {
                Set<Integer> set = this.partitions[i];
                if (set == null) continue;
                set.clear();
            }
        }

        private void check(int index) {
            if (index < 0 || index >= 7) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleNodeGroup
    implements NodeGroup {
        final PartitionTable nodeTable;
        Address address;
        Set<Address> nodes;

        private SingleNodeGroup() {
            this.nodeTable = new PartitionTable();
            this.address = null;
        }

        @Override
        public void addNode(Address addr) {
            if (this.address != null) {
                logger.log(Level.WARNING, "Single node group already has an address => " + this.address);
                return;
            }
            this.address = addr;
            this.nodes = Collections.singleton(this.address);
        }

        @Override
        public boolean hasNode(Address address) {
            return this.address != null && this.address.equals(address);
        }

        @Override
        public Set<Address> getNodes() {
            return this.nodes;
        }

        @Override
        public PartitionTable getPartitionTable(Address address) {
            return this.hasNode(address) ? this.nodeTable : null;
        }

        @Override
        public void resetPartitions() {
            this.nodeTable.reset();
        }

        @Override
        public int getPartitionCount(int index) {
            return this.nodeTable.size(index);
        }

        @Override
        public boolean containsPartition(Integer partitionId) {
            return this.nodeTable.contains(partitionId);
        }

        @Override
        public boolean ownPartition(Address address, int index, Integer partitionId) {
            if (!this.hasNode(address)) {
                String error = address + " is different from this node's " + this.address;
                logger.log(Level.WARNING, error);
                return false;
            }
            if (this.containsPartition(partitionId)) {
                String error = "Partition[" + partitionId + "] is already owned by this node " + address + "! Duplicate!";
                logger.log(Level.FINEST, error);
                return false;
            }
            return this.nodeTable.add(index, partitionId);
        }

        @Override
        public boolean addPartition(int replicaIndex, Integer partitionId) {
            if (this.containsPartition(partitionId)) {
                return false;
            }
            return this.nodeTable.add(replicaIndex, partitionId);
        }

        @Override
        public Iterator<Integer> getPartitionsIterator(int index) {
            return this.nodeTable.getPartitions(index).iterator();
        }

        @Override
        public boolean removePartition(int index, Integer partitionId) {
            return this.nodeTable.remove(index, partitionId);
        }

        @Override
        public void postProcessPartitionTable(int index) {
        }

        public String toString() {
            return "SingleNodeGroupRegistry [address=" + this.address + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultNodeGroup
    implements NodeGroup {
        final PartitionTable groupPartitionTable;
        final Map<Address, PartitionTable> nodePartitionTables;
        final Set<Address> nodes;
        final Collection<PartitionTable> nodeTables;
        final LinkedList<Integer> partitionQ;

        private DefaultNodeGroup() {
            this.groupPartitionTable = new PartitionTable();
            this.nodePartitionTables = new HashMap<Address, PartitionTable>();
            this.nodes = this.nodePartitionTables.keySet();
            this.nodeTables = this.nodePartitionTables.values();
            this.partitionQ = new LinkedList();
        }

        @Override
        public void addNode(Address address) {
            this.nodePartitionTables.put(address, new PartitionTable());
        }

        @Override
        public boolean hasNode(Address address) {
            return this.nodes.contains(address);
        }

        @Override
        public Set<Address> getNodes() {
            return this.nodes;
        }

        @Override
        public PartitionTable getPartitionTable(Address address) {
            return this.nodePartitionTables.get(address);
        }

        @Override
        public void resetPartitions() {
            this.groupPartitionTable.reset();
            this.partitionQ.clear();
            for (PartitionTable table : this.nodeTables) {
                table.reset();
            }
        }

        @Override
        public int getPartitionCount(int index) {
            return this.groupPartitionTable.size(index);
        }

        @Override
        public boolean containsPartition(Integer partitionId) {
            return this.groupPartitionTable.contains(partitionId);
        }

        @Override
        public boolean ownPartition(Address address, int index, Integer partitionId) {
            if (!this.hasNode(address)) {
                String error = "Address does not belong to this group: " + address.toString();
                logger.log(Level.WARNING, error);
                return false;
            }
            if (this.containsPartition(partitionId)) {
                String error = "Partition[" + partitionId + "] is already owned by this group! " + "Duplicate!";
                logger.log(Level.FINEST, error);
                return false;
            }
            this.groupPartitionTable.add(index, partitionId);
            return this.nodePartitionTables.get(address).add(index, partitionId);
        }

        @Override
        public boolean addPartition(int replicaIndex, Integer partitionId) {
            if (this.containsPartition(partitionId)) {
                return false;
            }
            if (this.groupPartitionTable.add(replicaIndex, partitionId)) {
                this.partitionQ.add(partitionId);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Integer> getPartitionsIterator(final int index) {
            final Iterator<Integer> iter = this.groupPartitionTable.getPartitions(index).iterator();
            return new Iterator<Integer>(){
                Integer current = null;

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Integer next() {
                    this.current = (Integer)iter.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    iter.remove();
                    DefaultNodeGroup.this.doRemovePartition(index, this.current);
                }
            };
        }

        @Override
        public boolean removePartition(int index, Integer partitionId) {
            if (this.groupPartitionTable.remove(index, partitionId)) {
                this.doRemovePartition(index, partitionId);
                return true;
            }
            return false;
        }

        private void doRemovePartition(int index, Integer partitionId) {
            for (PartitionTable table : this.nodeTables) {
                if (table.remove(index, partitionId)) break;
            }
        }

        @Override
        public void postProcessPartitionTable(int index) {
            if (this.nodes.size() == 1) {
                PartitionTable table = this.nodeTables.iterator().next();
                while (!this.partitionQ.isEmpty()) {
                    table.add(index, this.partitionQ.poll());
                }
            } else {
                int totalCount = this.getPartitionCount(index);
                int avgCount = totalCount / this.nodes.size();
                LinkedList<PartitionTable> underLoadedStates = new LinkedList<PartitionTable>();
                for (PartitionTable table : this.nodeTables) {
                    Set<Integer> partitions = table.getPartitions(index);
                    if (partitions.size() > avgCount) {
                        Iterator<Integer> iter = partitions.iterator();
                        while (partitions.size() > avgCount) {
                            Integer partitionId = iter.next();
                            iter.remove();
                            this.partitionQ.add(partitionId);
                        }
                        continue;
                    }
                    underLoadedStates.add(table);
                }
                if (!this.partitionQ.isEmpty()) {
                    for (PartitionTable table : underLoadedStates) {
                        while (table.size(index) < avgCount) {
                            table.add(index, this.partitionQ.poll());
                        }
                    }
                }
                block5: while (!this.partitionQ.isEmpty()) {
                    for (PartitionTable table : this.nodeTables) {
                        table.add(index, this.partitionQ.poll());
                        if (!this.partitionQ.isEmpty()) continue;
                        continue block5;
                    }
                }
            }
        }

        public String toString() {
            return "DefaultNodeGroupRegistry [nodes=" + this.nodes + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface NodeGroup {
        public void addNode(Address var1);

        public boolean hasNode(Address var1);

        public Set<Address> getNodes();

        public PartitionTable getPartitionTable(Address var1);

        public void resetPartitions();

        public int getPartitionCount(int var1);

        public boolean containsPartition(Integer var1);

        public boolean ownPartition(Address var1, int var2, Integer var3);

        public boolean addPartition(int var1, Integer var2);

        public Iterator<Integer> getPartitionsIterator(int var1);

        public boolean removePartition(int var1, Integer var2);

        public void postProcessPartitionTable(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TestResult {
        PASS,
        RETRY,
        FAIL;

    }

    private class CopyStateInitializer
    implements StateInitializer {
        private final PartitionInfo[] currentState;

        CopyStateInitializer(PartitionInfo[] currentState) {
            this.currentState = currentState;
        }

        public void initialize(PartitionInfo[] state) {
            if (state.length != this.currentState.length) {
                throw new IllegalArgumentException("Partition counts do not match!");
            }
            for (int i = 0; i < state.length; ++i) {
                PartitionInfo p = this.currentState[i];
                state[i] = new PartitionInfo(p.getPartitionId());
                state[i].setPartitionInfo(p);
            }
        }
    }

    private class EmptyStateInitializer
    implements StateInitializer {
        private EmptyStateInitializer() {
        }

        public void initialize(PartitionInfo[] state) {
            for (int i = 0; i < state.length; ++i) {
                state[i] = new PartitionInfo(i);
            }
        }
    }

    private static interface StateInitializer {
        public void initialize(PartitionInfo[] var1);
    }
}

