/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalTopicOperationStatsImpl;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalTopicOperationStats;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicOperationsCounter
extends OperationsCounterSupport<LocalTopicOperationStats> {
    private static final LocalTopicOperationStats empty = new LocalTopicOperationStatsImpl();
    private AtomicLong messagePublishes = new AtomicLong();
    private AtomicLong receivedMessages = new AtomicLong();

    public TopicOperationsCounter() {
    }

    public TopicOperationsCounter(long interval) {
        super(interval);
    }

    TopicOperationsCounter getAndReset() {
        TopicOperationsCounter newOne = new TopicOperationsCounter();
        newOne.messagePublishes.set(this.messagePublishes.getAndSet(0L));
        newOne.receivedMessages.set(this.receivedMessages.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    public void incrementPublishes() {
        this.messagePublishes.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedMessages() {
        this.receivedMessages.incrementAndGet();
        this.publishSubResult();
    }

    @Override
    LocalTopicOperationStats aggregateSubCounterStats() {
        LocalTopicOperationStatsImpl stats = new LocalTopicOperationStatsImpl();
        stats.periodStart = ((TopicOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        for (int i = 0; i < this.listOfSubCounters.size(); ++i) {
            TopicOperationsCounter sub = (TopicOperationsCounter)this.listOfSubCounters.get(i);
            stats.numberOfPublishes += sub.messagePublishes.get();
            stats.numberOfReceives += sub.receivedMessages.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    @Override
    LocalTopicOperationStats getThis() {
        LocalTopicOperationStatsImpl stats = new LocalTopicOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfPublishes = this.messagePublishes.get();
        stats.numberOfReceives = this.receivedMessages.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalTopicOperationStats getEmpty() {
        return empty;
    }
}

