/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;

public class Encoding {
    private static final Encoding DEFAULT_ENCODING = new Encoding(null);
    private static final Hashtable encodings = new Hashtable();
    private final String encoding;
    private final boolean utf8;
    private char[] decoderArray = new char[1024];

    private Encoding(String encoding) {
        this.encoding = encoding;
        this.utf8 = encoding != null && (encoding.equals("UTF-8") || encoding.equals("UTF8"));
    }

    public static Encoding getJVMEncoding(String jvmEncoding) {
        if (Encoding.isAvailable(jvmEncoding)) {
            return new Encoding(jvmEncoding);
        }
        return Encoding.defaultEncoding();
    }

    public static Encoding getDatabaseEncoding(String databaseEncoding) {
        if (encodings.containsKey(databaseEncoding)) {
            String[] candidates = (String[])encodings.get(databaseEncoding);
            for (int i = 0; i < candidates.length; ++i) {
                if (!Encoding.isAvailable(candidates[i])) continue;
                return new Encoding(candidates[i]);
            }
        }
        if (Encoding.isAvailable(databaseEncoding)) {
            return new Encoding(databaseEncoding);
        }
        return Encoding.defaultEncoding();
    }

    public String name() {
        return this.encoding;
    }

    public byte[] encode(String s) throws IOException {
        if (s == null) {
            return null;
        }
        if (this.encoding == null) {
            return s.getBytes();
        }
        return s.getBytes(this.encoding);
    }

    public String decode(byte[] encodedString, int offset, int length) throws IOException {
        if (this.encoding == null) {
            return new String(encodedString, offset, length);
        }
        if (this.utf8) {
            return this.decodeUTF8(encodedString, offset, length);
        }
        return new String(encodedString, offset, length, this.encoding);
    }

    public String decode(byte[] encodedString) throws IOException {
        return this.decode(encodedString, 0, encodedString.length);
    }

    public Reader getDecodingReader(InputStream in) throws IOException {
        if (this.encoding == null) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(in, this.encoding);
    }

    public Writer getEncodingWriter(OutputStream out) throws IOException {
        if (this.encoding == null) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, this.encoding);
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean isAvailable(String encodingName) {
        try {
            "DUMMY".getBytes(encodingName);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    private synchronized String decodeUTF8(byte[] data, int offset, int length) throws IOException {
        char[] cdata = this.decoderArray;
        if (cdata.length < length) {
            cdata = this.decoderArray = new char[length];
        }
        int in = offset;
        int out = 0;
        int end = length + offset;
        try {
            while (in < end) {
                int ch;
                if ((ch = data[in++] & 0xFF) >= 128) {
                    if (ch < 224) {
                        ch = (ch & 0x1F) << 6;
                        ch |= data[in++] & 0x3F;
                    } else {
                        ch = (ch & 0xF) << 12;
                        ch |= (data[in++] & 0x3F) << 6;
                        ch |= data[in++] & 0x3F;
                    }
                }
                cdata[out++] = (char)ch;
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw new IOException("UTF-8 string representation was truncated");
        }
        if (in > end) {
            throw new IOException("UTF-8 string representation was truncated");
        }
        return new String(cdata, 0, out);
    }

    public String toString() {
        return this.encoding == null ? "<default JVM encoding>" : this.encoding;
    }

    static {
        encodings.put("SQL_ASCII", new String[]{"ASCII", "us-ascii"});
        encodings.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodings.put("LATIN1", new String[]{"ISO8859_1"});
        encodings.put("LATIN2", new String[]{"ISO8859_2"});
        encodings.put("LATIN3", new String[]{"ISO8859_3"});
        encodings.put("LATIN4", new String[]{"ISO8859_4"});
        encodings.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodings.put("ISO_8859_6", new String[]{"ISO8859_6"});
        encodings.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodings.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodings.put("LATIN5", new String[]{"ISO8859_9"});
        encodings.put("LATIN7", new String[]{"ISO8859_13"});
        encodings.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        encodings.put("EUC_JP", new String[]{"EUC_JP"});
        encodings.put("EUC_CN", new String[]{"EUC_CN"});
        encodings.put("EUC_KR", new String[]{"EUC_KR"});
        encodings.put("JOHAB", new String[]{"Johab"});
        encodings.put("EUC_TW", new String[]{"EUC_TW"});
        encodings.put("SJIS", new String[]{"MS932", "SJIS"});
        encodings.put("BIG5", new String[]{"Big5", "MS950", "Cp950"});
        encodings.put("GBK", new String[]{"GBK", "MS936"});
        encodings.put("UHC", new String[]{"MS949", "Cp949", "Cp949C"});
        encodings.put("TCVN", new String[]{"Cp1258"});
        encodings.put("WIN1256", new String[]{"Cp1256"});
        encodings.put("WIN1250", new String[]{"Cp1250"});
        encodings.put("WIN874", new String[]{"MS874", "Cp874"});
        encodings.put("WIN", new String[]{"Cp1251"});
        encodings.put("ALT", new String[]{"Cp866"});
        encodings.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodings.put("UNKNOWN", new String[0]);
        encodings.put("MULE_INTERNAL", new String[0]);
        encodings.put("LATIN6", new String[0]);
        encodings.put("LATIN8", new String[0]);
        encodings.put("LATIN10", new String[0]);
    }
}

