/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.dataone.cn.indexer.parser.AbstractDocumentSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentProvider;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceMapSubprocessor
extends AbstractDocumentSubprocessor
implements IDocumentSubprocessor {
    private IDocumentProvider documentSource = null;
    private HTTPService httpService = null;
    private String solrQueryUri = null;

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, Document doc) throws IOException, EncoderException, SAXException, XPathExpressionException, ParserConfigurationException {
        SolrDoc resourceMapDoc = docs.get(identifier);
        List<SolrDoc> processedDocs = this.processResourceMap(resourceMapDoc, doc);
        HashMap<String, SolrDoc> processedDocsMap = new HashMap<String, SolrDoc>();
        for (SolrDoc processedDoc : processedDocs) {
            processedDocsMap.put(processedDoc.getIdentifier(), processedDoc);
        }
        return processedDocsMap;
    }

    private List<SolrDoc> processResourceMap(SolrDoc indexDocument, Document resourceMapDocument) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException, EncoderException {
        ResourceMap resourceMap = new ResourceMap(resourceMapDocument);
        List<String> documentIds = resourceMap.getAllDocumentIDs();
        List<SolrDoc> updateDocuments = this.getHttpService().getDocuments(this.getSolrQueryUri(), documentIds);
        List<SolrDoc> mergedDocuments = resourceMap.mergeIndexedDocuments(updateDocuments);
        mergedDocuments.add(indexDocument);
        return mergedDocuments;
    }

    public IDocumentProvider getDocumentSource() {
        return this.documentSource;
    }

    public void setDocumentSource(IDocumentProvider documentSource) {
        this.documentSource = documentSource;
    }

    public HTTPService getHttpService() {
        return this.httpService;
    }

    public void setHttpService(HTTPService httpService) {
        this.httpService = httpService;
    }

    public String getSolrQueryUri() {
        return this.solrQueryUri;
    }

    public void setSolrQueryUri(String solrQueryUri) {
        this.solrQueryUri = solrQueryUri;
    }
}

