/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Entity;

public class TableItem {
    private Entity entity = null;

    public TableItem(Entity entity) {
        this.entity = entity;
    }

    public String toSQLString() throws UnWellFormedQueryException {
        String tableName = null;
        if (this.entity != null) {
            try {
                tableName = DataManager.getDBTableName(this.entity);
            }
            catch (SQLException sqle) {
                System.err.println("entity name is null " + sqle.getMessage());
            }
            if (tableName == null || tableName.trim().equals("")) {
                throw new UnWellFormedQueryException("Entity name couldn't be null in \"From clause\"");
            }
        } else {
            throw new UnWellFormedQueryException("Entity couldn't be null in \"From clause\"");
        }
        return tableName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableItem) {
            TableItem tableItem = (TableItem)obj;
            return tableItem.entity.equals(this.entity);
        }
        return false;
    }
}

