/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities.config;

import edu.ucsb.nceas.utilities.config.exception.ElementNotFoundException;
import edu.ucsb.nceas.utilities.config.exception.IndexTooLargeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ConfigXML {
    private Node root;
    private Document doc;
    private String fileName;
    private PrintWriter out;
    private static final String configDirectory = ".morpho";

    private static DocumentBuilder createDomParser() throws Exception {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newDocumentBuilder();
            if (parser == null) {
                throw new Exception("Could not create Document parser in MonarchUtil.DocumentBuilder");
            }
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("Could not create Document parser in MonarchUtil.DocumentBuilder: " + pce.getMessage());
        }
        return parser;
    }

    public ConfigXML(String filename) throws FileNotFoundException, Exception {
        this.fileName = filename;
        DocumentBuilder parser = ConfigXML.createDomParser();
        File XMLConfigFile = new File(filename);
        FileInputStream fs = new FileInputStream(filename);
        InputSource in = new InputSource(fs);
        this.doc = parser.parse(in);
        fs.close();
        this.root = this.doc.getDocumentElement();
    }

    public ConfigXML(InputStream configStream) throws FileNotFoundException, Exception {
        DocumentBuilder parser = ConfigXML.createDomParser();
        InputSource in = new InputSource(configStream);
        this.doc = parser.parse(in);
        configStream.close();
        this.root = this.doc.getDocumentElement();
    }

    public Vector get(String key) throws ElementNotFoundException {
        NodeList nl = this.doc.getElementsByTagName(key);
        Vector<String> result = new Vector<String>();
        if (nl.getLength() < 1) {
            throw new ElementNotFoundException("Element " + key + " not found");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cn = nl.item(i).getFirstChild();
            if (cn == null || cn.getNodeType() != 3) continue;
            String temp = cn.getNodeValue();
            result.addElement(temp.trim());
        }
        return result;
    }

    public String get(String key, int i) throws ElementNotFoundException {
        NodeList nl = this.doc.getElementsByTagName(key);
        String result = null;
        if (nl.getLength() < 1) {
            throw new ElementNotFoundException("Element " + key + " not found at position " + i);
        }
        if (nl.getLength() < i) {
            throw new ElementNotFoundException("Element " + key + " not found at position " + i);
        }
        Node cn = nl.item(i).getFirstChild();
        if (cn != null && cn.getNodeType() == 3) {
            result = cn.getNodeValue().trim();
        }
        return result;
    }

    public void set(String key, int i, String value) throws ElementNotFoundException {
        boolean result = false;
        NodeList nl = this.doc.getElementsByTagName(key);
        if (nl.getLength() <= i) {
            throw new ElementNotFoundException("Cannot set key " + key + " at position " + i + " either because it does not exist " + "or because the there are not " + i + " elements by that name.");
        }
        Node cn = nl.item(i).getFirstChild();
        if (cn == null) {
            Text newText = this.doc.createTextNode(value);
            nl.item(i).appendChild(newText);
        } else if (cn.getNodeType() == 3) {
            cn.setNodeValue(value);
        }
    }

    public void insert(String key, String value) {
        Element newElem = this.doc.createElement(key);
        Text newText = this.doc.createTextNode(value);
        newElem.appendChild(newText);
        NodeList nl = this.doc.getElementsByTagName(key);
        if (nl.getLength() > 0) {
            Node nnn = nl.item(0);
            Node parent = nnn.getParentNode();
            parent.insertBefore(newElem, nnn);
        } else {
            this.root.appendChild(newElem);
        }
    }

    public void addSubField(String parentName, int i, String childName, String value) throws IndexTooLargeException {
        NodeList nl = this.doc.getElementsByTagName(parentName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                throw new IndexTooLargeException("Error setting XMLConfig value: index too large");
            }
            Node parent = nl.item(i);
            Element newElem = this.doc.createElement(childName);
            Text newText = this.doc.createTextNode(value);
            newElem.appendChild(newText);
            parent.appendChild(newElem);
        }
    }

    public void delete(String nodeName, int i) throws IndexTooLargeException {
        NodeList nl = this.doc.getElementsByTagName(nodeName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                throw new IndexTooLargeException("Error removing XMLConfig value: index too large");
            }
            Node nnn = nl.item(i);
            Node parent = nnn.getParentNode();
            parent.removeChild(nnn);
        }
    }

    public void deleteSubFields(String parentName, int i) throws IndexTooLargeException {
        NodeList nl = this.doc.getElementsByTagName(parentName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                throw new IndexTooLargeException("Error setting XMLConfig value: index too large");
            }
            Node parent = nl.item(i);
            NodeList nlchildren = parent.getChildNodes();
            int numchildren = nlchildren.getLength();
            for (int k = 0; k < numchildren; ++k) {
                Node temp = nlchildren.item(0);
                parent.removeChild(temp);
            }
        }
    }

    public Hashtable getNameValuePairs(String field, String name, String value) throws ElementNotFoundException {
        try {
            Hashtable h = this.getNameValuePairs(field, name, value, 0);
            return h;
        }
        catch (IndexTooLargeException e) {
            throw new ElementNotFoundException("The element " + field + " does not exist.");
        }
    }

    public Hashtable getNameValuePairs(String field, String name, String value, int i) throws IndexTooLargeException {
        String keyval = "";
        String valval = "";
        Hashtable<String, String> ht = new Hashtable<String, String>();
        NodeList nl = this.doc.getElementsByTagName(field);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                throw new IndexTooLargeException("There are not " + i + " nodes in " + "the resultset.");
            }
            NodeList children = nl.item(i).getChildNodes();
            if (children.getLength() > 0) {
                for (int j = 0; j < children.getLength(); ++j) {
                    Node ccn;
                    Node cn = children.item(j);
                    if (cn.getNodeType() == 1 && cn.getNodeName().equalsIgnoreCase(name) && (ccn = cn.getFirstChild()) != null && ccn.getNodeType() == 3) {
                        keyval = ccn.getNodeValue();
                    }
                    if (cn.getNodeType() != 1 || !cn.getNodeName().equalsIgnoreCase(value) || (ccn = cn.getFirstChild()) == null || ccn.getNodeType() != 3) continue;
                    valval = ccn.getNodeValue();
                    ht.put(keyval, valval);
                }
            }
        }
        return ht;
    }

    public Vector getValuesForPath(String pathstring) throws ElementNotFoundException, Exception {
        Vector<String> val;
        block5: {
            val = new Vector<String>();
            if (!pathstring.startsWith("/")) {
                pathstring = "//*/" + pathstring;
            }
            NodeList nl = null;
            nl = XPathAPI.selectNodeList((Node)this.doc, (String)pathstring);
            if (nl != null && nl.getLength() > 0) {
                for (int k = 0; k < nl.getLength(); ++k) {
                    Node cn = nl.item(k).getFirstChild();
                    if (cn == null || cn.getNodeType() != 3) continue;
                    String temp = cn.getNodeValue().trim();
                    val.addElement(temp);
                }
                break block5;
            }
            throw new ElementNotFoundException("The path " + pathstring + " was not found.");
        }
        return val;
    }

    public NodeList getPathContent(String path) throws TransformerException, ElementNotFoundException {
        NodeList docNodeList = XPathAPI.selectNodeList((Node)this.doc, (String)path);
        if (docNodeList == null || docNodeList.getLength() == 0) {
            throw new ElementNotFoundException("Path " + path + " was not found.");
        }
        return docNodeList;
    }

    public void save() throws Exception {
        this.saveDOM(this.root);
    }

    private void saveDOM(Node nd) throws Exception {
        File outfile = new File(this.fileName);
        if (!outfile.canWrite()) {
            throw new Exception("Cannot write the config file " + this.fileName);
        }
        this.out = new PrintWriter(new FileWriter(this.fileName));
        this.out.println("<?xml version=\"1.0\"?>");
        this.print(nd);
        this.out.close();
    }

    private void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.out.println("<?xml version=\"1.0\"?>");
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                break;
            }
            case 5: {
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block6;
                }
                case '>': {
                    str.append("&gt;");
                    continue block6;
                }
                case '&': {
                    str.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block6;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String getConfigDirectory() {
        return System.getProperty("user.home") + File.separator + configDirectory;
    }
}

