/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.exceptions.UnsupportedProtocolException;
import edu.uiuc.ncsa.security.delegation.server.issuers.AGIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.AbstractIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.AGRequest;
import edu.uiuc.ncsa.security.delegation.server.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.oauth_1_0a.server.AGResponseImpl;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.PublicKey;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;

public class AGIImpl
extends AbstractIssuer
implements AGIssuer {
    public AGIImpl(TokenForge tokenForge, URI address) {
        super(tokenForge, address);
    }

    public AGResponse processAGRequest(AGRequest agReq) {
        try {
            OAuthMessage m = OAuthUtilities.getMessage(agReq.getServletRequest());
            if (!(agReq.getClient() instanceof OAClient)) {
                throw new NotImplementedException("This is only implemented for OAuth client. The class found was " + agReq.getClient().getClass().getName());
            }
            OAClient oaClient = (OAClient)agReq.getClient();
            OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor((AddressableServer)this, oaClient);
            if (oaClient.getSignatureMethod().equals("RSA-SHA1")) {
                PublicKey pk = KeyUtil.fromX509PEM((String)oaClient.getSecret());
                accessor.consumer.setProperty("RSA-SHA1.PublicKey", (Object)pk);
                accessor.setProperty("RSA-SHA1.PublicKey", (Object)pk);
            }
            OAuthUtilities.validate(m, accessor);
            AuthorizationGrant ag = this.tokenForge.getAuthorizationGrant(new String[0]);
            AGResponseImpl agResponse = new AGResponseImpl();
            agResponse.setGrant(ag);
            agResponse.setParameters(OAuthUtilities.getParameters(m));
            Map<String, String> params = agResponse.getParameters();
            String certReq = params.get("certreq");
            if (this.isEmpty(certReq)) {
                throw new GeneralException("Error: No cert request");
            }
            String certLifetimeString = params.get("certlifetime");
            long certLifetime = 0L;
            if (!this.isEmpty(certLifetimeString)) {
                try {
                    certLifetime = Long.parseLong(certLifetimeString) * 1000L;
                    if (certLifetime < 0L) {
                        certLifetime = 0L;
                    }
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
            }
            params.put("certlifetime", Long.toString(certLifetime));
            String callback = params.get("oauth_callback");
            if (this.isEmpty(callback)) {
                throw new GeneralException("Error: No callback specified");
            }
            URI cb = URI.create(callback);
            if (cb.getScheme() == null || !cb.getScheme().equals("https")) {
                throw new UnsupportedProtocolException("Error: protocol in the callback must be https");
            }
            return agResponse;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException((Throwable)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

