/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.Callback;

public class Context {
    public static final Context emptyContext = new Context(true);
    protected Map<Symbol, Object> context = new HashMap<Symbol, Object>();
    protected List<Callback<Symbol>> callbacks = new ArrayList<Callback<Symbol>>();
    protected boolean readonly = false;

    public Context() {
    }

    private Context(boolean readonly) {
        this.readonly = readonly;
    }

    public Context(Context cxt) {
        this.putAll(cxt);
    }

    public Context copy() {
        return new Context(this);
    }

    public Object get(Symbol property) {
        return this.context.get(property);
    }

    public Object get(Symbol property, Object defaultValue) {
        Object x = this.context.get(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public void put(Symbol property, Object value) {
        this._put(property, value);
        this.doCallbacks(property);
    }

    public void set(Symbol property, Object value) {
        this._put(property, value);
        this.doCallbacks(property);
    }

    private void _put(Symbol property, Object value) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        this.context.put(property, value);
    }

    public void set(Symbol property, boolean value) {
        if (value) {
            this.setTrue(property);
        } else {
            this.setFalse(property);
        }
    }

    public void setIfUndef(Symbol property, Object value) {
        Object x = this.context.get(property);
        if (x == null) {
            this.put(property, value);
        }
    }

    public void remove(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public void unset(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public boolean isDefined(Symbol property) {
        return this.context.containsKey(property);
    }

    public boolean isUndef(Symbol property) {
        return !this.isDefined(property);
    }

    public String getAsString(Symbol property, String defaultValue) {
        String x = this.getAsString(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public String getAsString(Symbol property) {
        Object x = this.context.get(property);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public void putAll(Context other) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        if (other != null) {
            for (Map.Entry<Symbol, Object> e2 : other.context.entrySet()) {
                this.put(e2.getKey(), e2.getValue());
            }
        }
    }

    public void setTrue(Symbol property) {
        this.set(property, Boolean.TRUE);
    }

    public void setFalse(Symbol property) {
        this.set(property, Boolean.FALSE);
    }

    public boolean isTrue(Symbol property) {
        return this.isTrue(property, false);
    }

    public boolean isTrueOrUndef(Symbol property) {
        return this.isTrue(property, true);
    }

    private boolean isTrue(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("true")) {
            return true;
        }
        return x.equals(Boolean.TRUE);
    }

    public boolean isFalse(Symbol property) {
        return this.isFalse(property, false);
    }

    public boolean isFalseOrUndef(Symbol property) {
        return this.isFalse(property, true);
    }

    private boolean isFalse(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("false")) {
            return true;
        }
        return x.equals(Boolean.FALSE);
    }

    public boolean hasValue(Symbol property, Object value) {
        Object x = this.get(property);
        if (x == null && value == null) {
            return true;
        }
        if (x == null || value == null) {
            return false;
        }
        return x.equals(value);
    }

    public boolean hasValueAsString(Symbol property, String value) {
        return this.hasValueAsString(property, value, false);
    }

    public boolean hasValueAsString(Symbol property, String value, boolean ignoreCase) {
        String s = this.getAsString(property);
        if (s == null && value == null) {
            return true;
        }
        if (s == null || value == null) {
            return false;
        }
        if (ignoreCase) {
            return s.equalsIgnoreCase(value);
        }
        return s.equals(value);
    }

    public Set<Symbol> keys() {
        return this.context.keySet();
    }

    public int size() {
        return this.context.size();
    }

    public void addCallback(Callback<Symbol> m) {
        this.callbacks.add(m);
    }

    public void removeCallback(Callback<Symbol> m) {
        this.callbacks.remove(m);
    }

    public List<Callback<Symbol>> getCallbacks() {
        return this.callbacks;
    }

    private void doCallbacks(Symbol symbol) {
        for (Callback<Symbol> c : this.callbacks) {
            c.proc(symbol);
        }
    }

    public String toString() {
        String x = "";
        String sep = "";
        for (Symbol s : this.keys()) {
            Object value = this.get(s);
            x = x + sep + s + " = " + value;
            sep = "\n";
        }
        return x;
    }

    public static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset != null && dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context;
    }
}

