/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAccSink;
import com.hp.hpl.jena.sparql.syntax.TripleCollectorMark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.lib.SinkToCollection;

public class QuadDataAcc
extends QuadDataAccSink
implements TripleCollectorMark {
    private final List<Quad> quads;
    private final List<Quad> quadsView;

    public QuadDataAcc() {
        this(new ArrayList<Quad>());
    }

    public QuadDataAcc(List<Quad> quads) {
        super(new SinkToCollection<Quad>(quads));
        this.quads = quads;
        this.quadsView = Collections.unmodifiableList(quads);
    }

    public List<Quad> getQuads() {
        return this.quadsView;
    }

    public int hashCode() {
        return this.quads.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof QuadDataAcc)) {
            return false;
        }
        QuadDataAcc acc = (QuadDataAcc)other;
        return this.quads.equals(acc.quads);
    }

    @Override
    public int mark() {
        return this.quads.size();
    }

    @Override
    public void addTriple(int index, Triple triple) {
        this.check(triple);
        this.quads.add(index, new Quad(this.graphNode, triple));
    }

    @Override
    public void addTriplePath(int index, TriplePath tPath) {
        throw new UnsupportedOperationException("Can't add paths to quads");
    }
}

