/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.impl.MultipartCNode;
import org.dataone.client.v2.impl.MultipartD1Node;
import org.dataone.client.v2.impl.MultipartMNode;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class ObjectManager {
    private static ObjectManager manager = null;
    private static String dataRootDir = Settings.getConfiguration().getString("index.data.root.directory");
    private static String documentRootDir = Settings.getConfiguration().getString("index.document.root.directory");
    private static String nodeBaseURL = Settings.getConfiguration().getString("dataone.mn.baseURL");
    private static String DataONEauthToken = null;
    private static Logger logger = Logger.getLogger(ObjectManager.class);
    private static final String TOKEN_VARIABLE_NAME = "DATAONE_AUTH_TOKEN";
    private static final String TOKEN_FILE_PATH_PROP_NAME = "dataone.nodeToken.file";
    private static final String SYSTEMMETA_FILE_NAME = "systemmetadata.xml";
    private static MultipartD1Node d1Node = null;
    private static Session session = null;
    private static boolean ifDataAndDocRootSame = false;

    private ObjectManager() throws ServiceFailure {
        if (dataRootDir == null || dataRootDir.trim().equals("")) {
            throw new ServiceFailure("0000", "The data root directory specified by the property index.data.root.directory is blank in the properties file");
        }
        if (documentRootDir == null || documentRootDir.trim().equals("")) {
            throw new ServiceFailure("0000", "The metadata root directory specified by the property index.document.root.directory is blank in the properties file");
        }
        if (!Files.exists(FileSystems.getDefault().getPath(dataRootDir, new String[0]), new LinkOption[0])) {
            throw new ServiceFailure("0000", "The data root directory " + dataRootDir + " specified in the properties file doesn't exist");
        }
        if (!Files.exists(FileSystems.getDefault().getPath(documentRootDir, new String[0]), new LinkOption[0])) {
            throw new ServiceFailure("0000", "The document root directory " + documentRootDir + " specified in the properties file doesn't exist");
        }
        if (!dataRootDir.endsWith("/")) {
            dataRootDir = dataRootDir + "/";
        }
        if (!documentRootDir.endsWith("/")) {
            documentRootDir = documentRootDir + "/";
        }
        if (documentRootDir.equals(dataRootDir)) {
            ifDataAndDocRootSame = true;
        }
        logger.info((Object)("ObjectManager.constructor - the root document directory is " + documentRootDir + " and the root data directory is " + dataRootDir + " Are they same?" + ifDataAndDocRootSame));
        if (d1Node == null) {
            this.refreshD1Node();
        } else {
            logger.info((Object)("ObjectManager ---NOT going to create the d1node with the url " + nodeBaseURL + " since the ObjectManager already was assigned a d1node with the url " + d1Node.getNodeBaseServiceUrl()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectManager getInstance() throws ServiceFailure {
        if (manager != null) return manager;
        Class<ObjectManager> clazz = ObjectManager.class;
        synchronized (ObjectManager.class) {
            if (manager != null) return manager;
            manager = new ObjectManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public String getFilePath(String relativePath, String objectFormat) throws NotFound {
        String absolutePath = null;
        if (relativePath != null && !relativePath.trim().equals("")) {
            if (ifDataAndDocRootSame) {
                absolutePath = documentRootDir + relativePath;
            } else if (objectFormat != null && !objectFormat.trim().equals("")) {
                ObjectFormat format = ObjectFormatCache.getInstance().getFormat(objectFormat);
                absolutePath = format.getFormatType().equals("METADATA") ? documentRootDir + relativePath : dataRootDir + relativePath;
            }
        }
        logger.debug((Object)("ObjectManager.getFilePath - the absolute file path for the relative file path " + relativePath + " is " + absolutePath));
        return absolutePath;
    }

    public SystemMetadata getSystemMetadata(String id, String relativeObjPath) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InstantiationException, IllegalAccessException, IOException, MarshallingException {
        SystemMetadata sysmeta = null;
        long start = System.currentTimeMillis();
        File sysmetaFile = ObjectManager.getSysmetaFile(relativeObjPath);
        if (sysmetaFile != null) {
            sysmeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromFile(SystemMetadata.class, (File)sysmetaFile);
            long end = System.currentTimeMillis();
            logger.info((Object)("ObjectManager.getSystemMetadata - finish getting the system metadata via the file system for the pid " + id + " and it took " + (end - start) + "milliseconds"));
        } else {
            Identifier identifier = new Identifier();
            identifier.setValue(id);
            try {
                for (int i = 0; i < 5; ++i) {
                    try {
                        sysmeta = d1Node.getSystemMetadata(session, identifier);
                        break;
                    }
                    catch (ServiceFailure ee) {
                        logger.warn((Object)("The DataONE api call doesn't get the system metadata since " + ee.getMessage() + ". This is " + i + " try and Indexer will try again."));
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException ie) {
                            logger.info((Object)"The sleep of the thread was interrupted.");
                        }
                        continue;
                    }
                }
                logger.debug((Object)("ObjectManager.getSystemMetadata - finish getting the system metadata via the DataONE API call for the pid " + id));
            }
            catch (NotAuthorized e) {
                logger.info((Object)("ObjectManager.getSystemMetadata - failed to get the system metadata via the DataONE API call for the pid " + id + " since it is not authorized. We will refresh the token and try again"));
                this.refreshD1Node();
                sysmeta = d1Node.getSystemMetadata(session, identifier);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("ObjectManager.getSystemMetadata - finish getting the system metadata via DataONE API for the pid " + id + " and it took " + (end - start) + "milliseconds"));
        }
        return sysmeta;
    }

    public static void setD1Node(MultipartD1Node node) {
        d1Node = node;
    }

    protected static File getSysmetaFile(String relativeObjPath) {
        File sysmetaFile = null;
        String sysmetaPath = null;
        String relativeSysmetaPath = null;
        if (relativeObjPath != null) {
            if (relativeObjPath.contains(File.separator)) {
                logger.debug((Object)("ObjectManager.getSysmetaFile - the object file path " + relativeObjPath + " has at least one path separator " + File.pathSeparator));
                relativeSysmetaPath = relativeObjPath.substring(0, relativeObjPath.lastIndexOf(File.separator) + 1) + SYSTEMMETA_FILE_NAME;
            } else {
                logger.debug((Object)("ObjectManager.getSysmetaFile - the object file path " + relativeObjPath + " doesnot have any path separator " + File.pathSeparator));
                relativeSysmetaPath = SYSTEMMETA_FILE_NAME;
            }
            logger.debug((Object)("ObjectManager.getSysmetaFile - the relative system metadata file path for the object path " + relativeObjPath + " is " + relativeSysmetaPath));
            if (ifDataAndDocRootSame) {
                sysmetaPath = documentRootDir + relativeSysmetaPath;
                sysmetaFile = new File(sysmetaPath);
                if (!sysmetaFile.exists()) {
                    sysmetaPath = null;
                    sysmetaFile = null;
                }
            } else {
                sysmetaPath = documentRootDir + relativeSysmetaPath;
                sysmetaFile = new File(sysmetaPath);
                if (!sysmetaFile.exists() && !(sysmetaFile = new File(sysmetaPath = dataRootDir + relativeSysmetaPath)).exists()) {
                    sysmetaPath = null;
                    sysmetaFile = null;
                }
            }
        }
        logger.debug((Object)("ObjectManager.getSysmetaFile - the final system metadata file path for the object path " + relativeObjPath + " is " + sysmetaPath + ". Null means that not system metadata file exists."));
        return sysmetaFile;
    }

    private void refreshD1Node() throws ServiceFailure {
        DataONEauthToken = System.getenv(TOKEN_VARIABLE_NAME);
        if (DataONEauthToken == null || DataONEauthToken.trim().equals("")) {
            String tokenFilePath = Settings.getConfiguration().getString(TOKEN_FILE_PATH_PROP_NAME);
            if (tokenFilePath != null && !tokenFilePath.trim().equals("")) {
                logger.info((Object)("ObjectManager.refreshD1Node - We can't get the token from the env variable so try to get the auth token from the file " + tokenFilePath));
                try {
                    DataONEauthToken = FileUtils.readFileToString((File)new File(tokenFilePath), (String)"UTF-8");
                }
                catch (IOException e) {
                    DataONEauthToken = null;
                    logger.warn((Object)("ObjectManager.refreshD1Node - can NOT get the authen token from the file " + tokenFilePath + " since " + e.getMessage()));
                }
                if (DataONEauthToken != null && !DataONEauthToken.trim().equals("")) {
                    logger.info((Object)("ObjectManager.refreshD1Node - Got the auth token from the file " + tokenFilePath));
                }
            }
        } else {
            logger.info((Object)"ObjectManager.refreshD1Node - Got the auth token from an env. variable");
        }
        if (DataONEauthToken == null || DataONEauthToken.trim().equals("")) {
            logger.warn((Object)"ObjectManager.refreshD1Node ------ Could NOT get an auth token from either an env. variable or the properties file. So it will act as the public user.");
        }
        session = this.createSession(DataONEauthToken);
        logger.info((Object)("ObjectManager.refreshD1Node ------ going to create the d1node with url " + nodeBaseURL));
        try {
            d1Node = this.getMultipartD1Node(session, nodeBaseURL);
        }
        catch (IOException | ClientSideException e) {
            logger.error((Object)("ObjectManager.refreshD1Node - couldn't create the d1node for the url " + nodeBaseURL + " since " + e.getMessage()));
            throw new ServiceFailure("0000", e.getMessage());
        }
    }

    private Session createSession(String authToken) {
        Session session = null;
        if (authToken == null || authToken.trim().equals("")) {
            logger.info((Object)"ObjectManager.createSession - Creating the public session");
            session = new Session();
        } else {
            logger.info((Object)("ObjectManger.createSession - Creating authentication session from token: " + authToken.substring(0, 5) + "..."));
            session = new AuthTokenSession(authToken);
        }
        return session;
    }

    private MultipartD1Node getMultipartD1Node(Session session, String serviceUrl) throws IOException, ClientSideException {
        HttpMultipartRestClient mrc = null;
        MultipartCNode d1Node = null;
        mrc = new HttpMultipartRestClient();
        Boolean isCN = this.isCN(serviceUrl);
        if (isCN.booleanValue()) {
            logger.info((Object)("ObjectManager.getMultipartD1Node - creating cn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartCNode((MultipartRestClient)mrc, serviceUrl, session);
        } else {
            logger.info((Object)("ObjectManager.getMultipartD1Node - creating mn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartMNode((MultipartRestClient)mrc, serviceUrl, session);
        }
        return d1Node;
    }

    private Boolean isCN(String nodeStr) {
        Boolean isCN = false;
        if (nodeStr.matches("^\\s*urn:node:.*")) {
            if (nodeStr.matches("^\\s*urn:node:CN.*$|^\\s*urn:node:cn.*$")) {
                isCN = true;
                logger.debug((Object)("ObjectManager.isCN - The nodeId is for a CN: " + nodeStr));
            } else {
                logger.debug((Object)("ObjectManager.isCN - The nodeId is not for a CN: " + nodeStr));
                isCN = false;
            }
        } else if (nodeStr.matches("^\\s*https*://cn.*?\\.dataone\\.org.*$|https*://cn.*?\\.test\\.dataone\\.org.*$")) {
            isCN = true;
            logger.debug((Object)("ObjectManager.isCN - The service URL is for a CN: " + nodeStr));
        } else {
            logger.debug((Object)("ObjectManager.isCN - The service URL is not for a CN: " + nodeStr));
            isCN = false;
        }
        return isCN;
    }
}

