/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.security;

import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.security.DataONEAuthHelper;

public class DataONEAuthenticator
implements Authenticator<String, Customer> {
    Log log = LogFactory.getLog(DataONEAuthenticator.class);
    private final DataONEAuthHelper dataoneAuthHelper;

    public DataONEAuthenticator(DataONEAuthHelper dataoneAuthHelper) {
        this.dataoneAuthHelper = dataoneAuthHelper;
    }

    public Optional<Customer> authenticate(String token) throws AuthenticationException {
        Customer customer = null;
        boolean verified = this.dataoneAuthHelper.verify(token);
        if (verified) {
            customer = this.dataoneAuthHelper.getCustomerWithSubjectInfo(token);
        }
        if (customer != null) {
            return Optional.of(customer);
        }
        return Optional.empty();
    }
}

