/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AuthenticatedCipherText;
import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

@ThreadSafe
class AESGCMKW {
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static AuthenticatedCipherText encryptCEK(SecretKey cek, byte[] iv, SecretKey kek, Provider provider) throws JOSEException {
        AESEngine cipher = AES.createCipher(kek, true);
        GCMBlockCipher gcm = new GCMBlockCipher((BlockCipher)cipher);
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(kek.getEncoded()), 128, iv, null);
        gcm.init(true, (CipherParameters)aeadParams);
        int outputLength = gcm.getOutputSize(cek.getEncoded().length);
        byte[] output = new byte[outputLength];
        int outputOffset = gcm.processBytes(cek.getEncoded(), 0, cek.getEncoded().length, output, 0);
        try {
            outputOffset += gcm.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't generate GCM authentication tag for key: " + e.getMessage(), e);
        }
        int authTagLength = 16;
        byte[] cipherText = new byte[outputOffset - authTagLength];
        byte[] authTag = new byte[authTagLength];
        System.arraycopy(output, 0, cipherText, 0, cipherText.length);
        System.arraycopy(output, outputOffset - authTagLength, authTag, 0, authTag.length);
        return new AuthenticatedCipherText(cipherText, authTag);
    }

    public static SecretKey decryptCEK(SecretKey kek, byte[] iv, AuthenticatedCipherText authEncrCEK, int keyLength, Provider provider) throws JOSEException {
        AESEngine cipher = AES.createCipher(kek, false);
        GCMBlockCipher gcm = new GCMBlockCipher((BlockCipher)cipher);
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(kek.getEncoded()), 128, iv, null);
        gcm.init(false, (CipherParameters)aeadParams);
        byte[] cipherText = authEncrCEK.getCipherText();
        byte[] authTag = authEncrCEK.getAuthenticationTag();
        byte[] input = new byte[cipherText.length + authTag.length];
        System.arraycopy(cipherText, 0, input, 0, cipherText.length);
        System.arraycopy(authTag, 0, input, cipherText.length, authTag.length);
        int keyBytesLength = gcm.getOutputSize(input.length);
        byte[] keyBytes = new byte[keyBytesLength];
        int keyBytesOffset = gcm.processBytes(input, 0, input.length, keyBytes, 0);
        try {
            keyBytesOffset += gcm.doFinal(keyBytes, keyBytesOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException("Couldn't validate GCM authentication tag: " + e.getMessage(), e);
        }
        if (8 * keyBytes.length != keyLength) {
            throw new JOSEException("CEK key length mismatch: " + keyBytes.length + " != " + keyLength);
        }
        return new SecretKeySpec(keyBytes, "AES");
    }

    private AESGCMKW() {
    }
}

