/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

abstract class AggMinBase
extends AggregatorBase {
    protected final Expr expr;

    public AggMinBase(Expr expr) {
        this.expr = expr;
    }

    @Override
    public final Accumulator createAccumulator() {
        return new AccMin(this.expr);
    }

    @Override
    public final Expr getExpr() {
        return this.expr;
    }

    @Override
    public final Node getValueEmpty() {
        return null;
    }

    private static class AccMin
    extends AccumulatorExpr {
        private NodeValue minSoFar = null;
        static final boolean DEBUG = false;

        public AccMin(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.minSoFar == null) {
                this.minSoFar = nv;
                return;
            }
            int x = NodeValue.compareAlways(this.minSoFar, nv);
            if (x > 0) {
                this.minSoFar = nv;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.minSoFar;
        }
    }
}

