/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.stats;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.StatsMatcher;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.solver.stats.StatsResults;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;

public class Stats {
    static Item ZERO = Item.createNode((Node)NodeFactoryExtra.intToNode((int)0));

    public static void write(String filename, StatsResults stats) {
        Stats.write(filename, stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    public static void write(OutputStream output, StatsResults stats) {
        Stats.write(output, stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    private static void write(String filename, Map<Node, Integer> predicateStats, Map<Node, Integer> typeStats, long statsTotal) {
        try {
            FileOutputStream statsOut = new FileOutputStream(filename);
            Stats.write(statsOut, predicateStats, typeStats, statsTotal);
            ((OutputStream)statsOut).close();
        }
        catch (IOException ex) {
            Log.warn(Stats.class, (String)"Problem when writing stats file", (Throwable)ex);
        }
    }

    private static void write(OutputStream output, Map<Node, Integer> predicateStats, Map<Node, Integer> typeStats, long statsTotal) {
        Item item = Stats.format(predicateStats, typeStats, statsTotal);
        ItemWriter.write((OutputStream)output, (Item)item);
    }

    public static StatsCollector gather(Graph graph) {
        StatsCollector stats = new StatsCollector();
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            stats.record(null, t.getSubject(), t.getPredicate(), t.getObject());
        }
        return stats;
    }

    public static Item format(StatsResults stats) {
        return Stats.format(stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    private static Item format(Map<Node, Integer> predicates, Map<Node, Integer> types, long count) {
        Item stats = Item.createList();
        ItemList statsList = stats.getList();
        statsList.add("stats");
        Item meta = Item.createTagged((String)"meta");
        Item.addPair((ItemList)meta.getList(), (String)"timestamp", (Node)NodeFactoryExtra.nowAsDateTime());
        Item.addPair((ItemList)meta.getList(), (String)"run@", (String)Utils.nowAsString());
        if (count >= 0L) {
            Item.addPair((ItemList)meta.getList(), (String)"count", (Node)NodeFactoryExtra.intToNode((int)((int)count)));
        }
        statsList.add(meta);
        for (Map.Entry<Node, Integer> entry : types.entrySet()) {
            Node type = entry.getKey();
            Stats.addTypeTriple(statsList, type, NodeFactoryExtra.intToNode((int)entry.getValue()));
        }
        for (Map.Entry<Node, Integer> entry : predicates.entrySet()) {
            Node node = entry.getKey();
            if (node.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            Item.addPair((ItemList)statsList, (Node)node, (Node)NodeFactoryExtra.intToNode((int)entry.getValue()));
        }
        Item.addPair((ItemList)statsList, (Item)StatsMatcher.OTHER, (Item)ZERO);
        return stats;
    }

    private static void addTypeTriple(ItemList statsList, Node type, Node intCount) {
        ItemList triple = new ItemList();
        triple.add("VAR");
        triple.add(NodeConst.nodeRDFType);
        triple.add(type);
        Item.addPair((ItemList)statsList, (Item)Item.createList((ItemList)triple), (Item)Item.createNode((Node)intCount));
    }
}

