/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIF;

public class LDIFWriter
extends LDAPWriter {
    private String m_sep;
    private boolean m_foldLines;
    private boolean m_attrsOnly;
    private boolean m_toFiles;
    private static final String DEFAULT_SEPARATOR = ":";
    private static final int MAX_LINE = 77;

    public LDIFWriter(PrintWriter printWriter) {
        this(printWriter, false, DEFAULT_SEPARATOR, true, false);
    }

    public LDIFWriter(PrintWriter printWriter, boolean bl, String string, boolean bl2, boolean bl3) {
        super(printWriter);
        this.m_attrsOnly = bl;
        this.m_sep = string;
        this.m_foldLines = bl2;
        this.m_toFiles = bl3;
    }

    protected FileOutputStream getTempFile(String string) throws IOException {
        String string2;
        File file;
        int n = 0;
        do {
            string2 = String.valueOf(string) + '.' + n;
            file = new File(string2);
            ++n;
        } while (file.exists());
        this.printString(String.valueOf(string) + this.m_sep + " " + string2);
        return new FileOutputStream(file);
    }

    protected void printAttribute(LDAPAttribute lDAPAttribute) {
        String string = lDAPAttribute.getName();
        if (this.m_attrsOnly) {
            this.printString(String.valueOf(string) + this.m_sep);
            return;
        }
        Enumeration enumeration = lDAPAttribute.getByteValues();
        if (enumeration != null) {
            if (this.m_toFiles) {
                try {
                    FileOutputStream fileOutputStream = this.getTempFile(string);
                    fileOutputStream.write((byte[])enumeration.nextElement());
                }
                catch (Exception exception) {
                    System.err.println("Error writing values of " + string + ", " + exception.toString());
                    System.exit(1);
                }
            } else {
                byte[] byArray = (byte[])enumeration.nextElement();
                if (LDIF.isPrintable(byArray)) {
                    String string2;
                    try {
                        string2 = new String(byArray, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string2 = "";
                    }
                    this.printString(String.valueOf(string) + this.m_sep + " " + string2);
                } else {
                    String string3 = this.getPrintableValue(byArray);
                    if (string3.length() > 0) {
                        this.printString(String.valueOf(string) + ":: " + string3);
                    } else {
                        this.printString(String.valueOf(string) + this.m_sep + ' ');
                    }
                }
            }
        } else {
            this.printString(String.valueOf(string) + this.m_sep + ' ');
        }
    }

    protected void printEntryEnd(String string) {
        this.m_pw.println();
    }

    protected void printEntryStart(String string) {
        if (string == null) {
            string = "";
        } else {
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (!LDIF.isPrintable(byArray)) {
                string = this.getPrintableValue(byArray);
            }
        }
        this.printString("dn" + this.m_sep + " " + string);
    }

    protected void printString(String string) {
        if (this.m_foldLines) {
            LDIF.breakString(this.m_pw, string, 77);
        } else {
            this.m_pw.print(string);
            this.m_pw.print('\n');
        }
    }
}

