/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestVocabRDF
extends ModelTestBase {
    static final String RDFns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public TestVocabRDF(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestVocabRDF.class);
    }

    public void testRDFVocabulary() {
        String ns = RDFns;
        TestVocabRDF.assertEquals((String)ns, (String)RDF.getURI());
        TestVocabRDF.assertEquals((String)(ns + "Alt"), (String)RDF.Alt.getURI());
        TestVocabRDF.assertEquals((String)(ns + "Bag"), (String)RDF.Bag.getURI());
        TestVocabRDF.assertEquals((String)(ns + "Property"), (String)RDF.Property.getURI());
        TestVocabRDF.assertEquals((String)(ns + "Seq"), (String)RDF.Seq.getURI());
        TestVocabRDF.assertEquals((String)(ns + "Statement"), (String)RDF.Statement.getURI());
        TestVocabRDF.assertEquals((String)(ns + "List"), (String)RDF.List.getURI());
        TestVocabRDF.assertEquals((String)(ns + "nil"), (String)RDF.nil.getURI());
        TestVocabRDF.assertEquals((String)(ns + "type"), (String)RDF.type.getURI());
        TestVocabRDF.assertEquals((String)(ns + "rest"), (String)RDF.rest.getURI());
        TestVocabRDF.assertEquals((String)(ns + "first"), (String)RDF.first.getURI());
        TestVocabRDF.assertEquals((String)(ns + "subject"), (String)RDF.subject.getURI());
        TestVocabRDF.assertEquals((String)(ns + "predicate"), (String)RDF.predicate.getURI());
        TestVocabRDF.assertEquals((String)(ns + "object"), (String)RDF.object.getURI());
        TestVocabRDF.assertEquals((String)(ns + "value"), (String)RDF.value.getURI());
    }

    public void testLI() {
        String ns = RDFns;
        TestVocabRDF.assertEquals((String)(ns + "_1"), (String)RDF.li((int)1).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_1"), (String)RDF.li((int)1).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_10"), (String)RDF.li((int)10).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_11"), (String)RDF.li((int)11).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_100"), (String)RDF.li((int)100).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_123"), (String)RDF.li((int)123).getURI());
        TestVocabRDF.assertEquals((String)(ns + "_32768"), (String)RDF.li((int)32768).getURI());
    }

    public void testNodes() {
        TestVocabRDF.assertEquals((Object)RDF.Alt.asNode(), (Object)RDF.Nodes.Alt);
        TestVocabRDF.assertEquals((Object)RDF.Bag.asNode(), (Object)RDF.Nodes.Bag);
        TestVocabRDF.assertEquals((Object)RDF.Property.asNode(), (Object)RDF.Nodes.Property);
        TestVocabRDF.assertEquals((Object)RDF.Seq.asNode(), (Object)RDF.Nodes.Seq);
        TestVocabRDF.assertEquals((Object)RDF.Statement.asNode(), (Object)RDF.Nodes.Statement);
        TestVocabRDF.assertEquals((Object)RDF.List.asNode(), (Object)RDF.Nodes.List);
        TestVocabRDF.assertEquals((Object)RDF.nil.asNode(), (Object)RDF.Nodes.nil);
        TestVocabRDF.assertEquals((Object)RDF.type.asNode(), (Object)RDF.Nodes.type);
        TestVocabRDF.assertEquals((Object)RDF.rest.asNode(), (Object)RDF.Nodes.rest);
        TestVocabRDF.assertEquals((Object)RDF.first.asNode(), (Object)RDF.Nodes.first);
        TestVocabRDF.assertEquals((Object)RDF.subject.asNode(), (Object)RDF.Nodes.subject);
        TestVocabRDF.assertEquals((Object)RDF.predicate.asNode(), (Object)RDF.Nodes.predicate);
        TestVocabRDF.assertEquals((Object)RDF.object.asNode(), (Object)RDF.Nodes.object);
        TestVocabRDF.assertEquals((Object)RDF.value.asNode(), (Object)RDF.Nodes.value);
    }
}

