/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import junit.framework.Assert;

public class AbstractTestGraphMem
extends AbstractTestGraph {
    public AbstractTestGraphMem(String name) {
        super(name);
    }

    public void testClosesReifier() {
        Graph g = this.getGraph();
        SimpleReifier r = (SimpleReifier)g.getReifier();
        g.close();
        AbstractTestGraphMem.assertTrue((boolean)r.isClosed());
    }

    public void testBrokenIndexes() {
        Graph g = this.getGraphWith("x R y; x S z");
        ExtendedIterator it = g.find(Node.ANY, Node.ANY, Node.ANY);
        it.removeNext();
        it.removeNext();
        AbstractTestGraphMem.assertFalse((boolean)g.find(AbstractTestGraphMem.node("x"), Node.ANY, Node.ANY).hasNext());
        AbstractTestGraphMem.assertFalse((boolean)g.find(Node.ANY, AbstractTestGraphMem.node("R"), Node.ANY).hasNext());
        AbstractTestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, AbstractTestGraphMem.node("y")).hasNext());
    }

    public void testBrokenSubject() {
        Graph g = this.getGraphWith("x brokenSubject y");
        ExtendedIterator it = g.find(AbstractTestGraphMem.node("x"), Node.ANY, Node.ANY);
        it.removeNext();
        AbstractTestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenPredicate() {
        Graph g = this.getGraphWith("x brokenPredicate y");
        ExtendedIterator it = g.find(Node.ANY, AbstractTestGraphMem.node("brokenPredicate"), Node.ANY);
        it.removeNext();
        AbstractTestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testBrokenObject() {
        Graph g = this.getGraphWith("x brokenObject y");
        ExtendedIterator it = g.find(Node.ANY, Node.ANY, AbstractTestGraphMem.node("y"));
        it.removeNext();
        AbstractTestGraphMem.assertFalse((boolean)g.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    public void testSizeAfterRemove() {
        Graph g = this.getGraphWith("x p y");
        ExtendedIterator it = g.find((TripleMatch)AbstractTestGraphMem.triple("x ?? ??"));
        it.removeNext();
        AbstractTestGraphMem.assertEquals((int)0, (int)g.size());
    }

    public void testUnnecessaryMatches() {
        Node_URI special = new Node_URI("eg:foo"){

            public boolean matches(Node s) {
                Assert.fail((String)"Matched called superfluously.");
                return true;
            }
        };
        Graph g = this.getGraphWith("x p y");
        g.add(new Triple((Node)special, (Node)special, (Node)special));
        this.exhaust((Iterator)g.find((Node)special, Node.ANY, Node.ANY));
        this.exhaust((Iterator)g.find(Node.ANY, (Node)special, Node.ANY));
        this.exhaust((Iterator)g.find(Node.ANY, Node.ANY, (Node)special));
    }

    protected void exhaust(Iterator it) {
        while (it.hasNext()) {
            it.next();
        }
    }
}

