/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.exceptions;

import java.io.StringWriter;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseException
extends Exception {
    static Logger logger = Logger.getLogger((String)BaseException.class.getName());
    private int code;
    private String detail_code;
    private String pidString;
    private String nodeIdString;
    private TreeMap<String, String> trace_information;
    public static final int FMT_XML = 0;
    public static final int FMT_JSON = 1;
    public static final int FMT_HTML = 2;
    private DocumentBuilder documentBuilder = null;
    private Transformer transformer = null;
    private StringWriter strWtr = new StringWriter();

    protected BaseException(int code, String detail_code, String description) {
        super(description);
        this.trace_information = new TreeMap();
        this.code = code;
        this.detail_code = detail_code;
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transformer = transformerFactory.newTransformer();
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("omit-xml-declaration", "no");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (ParserConfigurationException ex) {
            logger.error((Object)ex.getMessage());
        }
        catch (TransformerConfigurationException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    protected BaseException(int code, String detail_code, String pidString, String nodeIdString, String description, TreeMap<String, String> trace_information) {
        this(code, detail_code, description);
        this.setIdentifier(pidString);
        if (nodeIdString != null) {
            this.setNodeId(nodeIdString);
        }
        this.trace_information = trace_information == null ? new TreeMap() : trace_information;
    }

    protected BaseException(int code, String detail_code, String pidString, String description, TreeMap<String, String> trace_information) {
        this(code, detail_code, description);
        this.setIdentifier(pidString);
        this.trace_information = trace_information == null ? new TreeMap() : trace_information;
    }

    protected BaseException(int code, String detail_code, String description, TreeMap<String, String> trace_information) {
        this(code, detail_code, description);
        this.trace_information = trace_information;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setDetail_code(String detail_code) {
        this.detail_code = detail_code;
    }

    public String getDetail_code() {
        return this.detail_code;
    }

    @Deprecated
    public String getPid() {
        return this.pidString;
    }

    @Deprecated
    public void setPid(String p) {
        this.pidString = p;
    }

    public String getIdentifier() {
        return this.pidString;
    }

    public void setIdentifier(String p) {
        this.pidString = p;
    }

    public void setNodeId(String nodeIdString) {
        this.nodeIdString = nodeIdString;
    }

    public String getNodeId() {
        return this.nodeIdString;
    }

    public String getDescription() {
        return this.getMessage();
    }

    public void addTraceDetail(String key, String value) {
        this.trace_information.put(key, value);
    }

    public String getTraceDetail(String key) {
        return this.trace_information.get(key);
    }

    public Set<String> getTraceKeySet() {
        return this.trace_information.keySet();
    }

    public String serialize(int format) {
        switch (format) {
            case 0: {
                return this.serializeXML();
            }
            case 1: {
                return this.serializeJSON();
            }
            case 2: {
                return this.serializeHTML();
            }
        }
        return this.serializeXML();
    }

    private String serializeXML() {
        Document dom = this.documentBuilder.newDocument();
        Element errorNode = dom.createElement("error");
        errorNode.setAttribute("name", this.getName());
        errorNode.setAttribute("detailCode", this.getDetail_code());
        errorNode.setAttribute("errorCode", Integer.toString(this.getCode()));
        if (this.getIdentifier() != null) {
            errorNode.setAttribute("identifier", this.getIdentifier());
        }
        if (this.getNodeId() != null) {
            errorNode.setAttribute("nodeId", this.getNodeId());
        }
        Element description = dom.createElement("description");
        description.setTextContent(this.getDescription());
        dom.appendChild(errorNode);
        errorNode.appendChild(description);
        if (!this.trace_information.isEmpty()) {
            Element traceInformation = dom.createElement("traceInformation");
            for (String key : this.getTraceKeySet()) {
                Element value = dom.createElement("value");
                value.setAttribute("key", key);
                value.setTextContent(this.trace_information.get(key));
                traceInformation.appendChild(value);
            }
            errorNode.appendChild(traceInformation);
        }
        try {
            return this.domToString(dom);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            return ex.getMessage();
        }
    }

    private String getName() {
        String c = this.getClass().getName();
        return c.substring(c.lastIndexOf(".") + 1);
    }

    private String serializeJSON() {
        StringBuffer sb = new StringBuffer();
        sb.append("{'errorCode': ").append(this.getCode()).append(",\n");
        sb.append(" 'detailCode': ").append(this.getDetail_code()).append(",\n");
        if (this.getIdentifier() != null) {
            sb.append(" 'identifier': '").append(this.getIdentifier()).append("',\n");
        }
        if (this.getNodeId() != null) {
            sb.append(" 'nodeId': '").append(this.getNodeId()).append("',\n");
        }
        sb.append(" 'description': '").append(this.getDescription()).append("',\n");
        sb.append(" 'traceInformation': {\n");
        for (String key : this.getTraceKeySet()) {
            sb.append("    '").append(key).append("': '");
            sb.append(this.trace_information.get(key)).append("',\n");
        }
        sb.append("  }\n");
        sb.append("}\n");
        return sb.toString();
    }

    private String serializeHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n<body>\n");
        sb.append("  <p>\n");
        sb.append("    <dl>\n");
        sb.append("      <dt>Code</dt><dd class='errorCode'>").append(this.getCode()).append("</dd>\n");
        sb.append("      <dt>Detail Code</dt><dd class='detailCode'>").append(this.getDetail_code()).append("</dd>\n");
        sb.append("      <dt>Identifier</dt><dd class='identifier'>").append(this.getIdentifier()).append("</dd>\n");
        sb.append("      <dt>NodeId</dt><dd class='nodeid'>").append(this.getNodeId()).append("</dd>\n");
        sb.append("    </dl>\n");
        sb.append("  </p>\n");
        sb.append("  <p class='description'>").append(this.getDescription()).append("</p>\n");
        sb.append("  <div class='traceInformation'>\n");
        for (String key : this.getTraceKeySet()) {
            sb.append("    <dt>").append(key).append("</dt>\n");
            sb.append("    <dd>").append(this.trace_information.get(key)).append("</dd>\n");
        }
        sb.append("  </div>\n");
        sb.append("</body>\n</html>\n");
        return sb.toString();
    }

    private String domToString(Document document) throws Exception {
        String result = null;
        if (document != null) {
            StreamResult strResult = new StreamResult(this.strWtr);
            this.transformer.transform(new DOMSource(document.getDocumentElement()), strResult);
            result = strResult.getWriter().toString();
        }
        return result;
    }
}

