/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.LdapName;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.jndi.EventListenerAdapter;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.NamingEnumerationAdapter;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;

public abstract class ServerDirContext
extends ServerContext
implements EventDirContext {
    public ServerDirContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerDirContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        super(service, principal, dn);
    }

    public ServerDirContext(DirectoryService service, CoreSession session, Name bindDn) throws Exception {
        super(service, session, bindDn);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(new LdapName(name));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        Attributes attrs = null;
        try {
            attrs = ServerEntryUtils.toBasicAttributes((Entry)this.doLookupOperation(this.buildTarget(JndiUtils.fromName((Name)name))));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        return attrs;
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new LdapName(name), attrIds);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes attrs = null;
        try {
            attrs = ServerEntryUtils.toBasicAttributes((Entry)this.doLookupOperation(this.buildTarget(JndiUtils.fromName((Name)name)), attrIds));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        return attrs;
    }

    @Override
    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.modifyAttributes(new LdapName(name), modOp, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        ArrayList<ModificationItem> modItems = null;
        if (attrs != null) {
            modItems = new ArrayList<ModificationItem>(attrs.size());
            NamingEnumeration<? extends javax.naming.directory.Attribute> e = attrs.getAll();
            while (e.hasMore()) {
                modItems.add(new ModificationItem(modOp, e.next()));
            }
        }
        List newMods = null;
        try {
            newMods = ServerEntryUtils.convertToServerModification(modItems, (SchemaManager)this.getDirectoryService().getSchemaManager());
        }
        catch (LdapNoSuchAttributeException lnsae) {
            throw new InvalidAttributesException(lnsae.getMessage());
        }
        catch (LdapException le) {
            throw new InvalidAttributeValueException(le.getMessage());
        }
        try {
            this.doModifyOperation(this.buildTarget(JndiUtils.fromName((Name)name)), newMods);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes((Name)new LdapName(name), mods);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        List newMods;
        try {
            newMods = ServerEntryUtils.toServerModification((ModificationItem[])mods, (SchemaManager)this.getDirectoryService().getSchemaManager());
        }
        catch (LdapException le) {
            throw new InvalidAttributesException(le.getMessage());
        }
        try {
            this.doModifyOperation(this.buildTarget(JndiUtils.fromName((Name)name)), newMods);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
    }

    public void modifyAttributes(Name name, List<ModificationItem> mods) throws NamingException {
        List newMods;
        try {
            newMods = ServerEntryUtils.convertToServerModification(mods, (SchemaManager)this.getDirectoryService().getSchemaManager());
        }
        catch (LdapException le) {
            throw new InvalidAttributesException(le.getMessage());
        }
        try {
            this.doModifyOperation(this.buildTarget(JndiUtils.fromName((Name)name)), newMods);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(new LdapName(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (null == obj && null == attrs) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_499, (Object[])new Object[0]));
        }
        if (null == attrs) {
            super.bind(name, obj);
            return;
        }
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        Entry serverEntry = null;
        try {
            serverEntry = ServerEntryUtils.toServerEntry((Attributes)AttributeUtils.toCaseInsensitive((Attributes)attrs), (Dn)target, (SchemaManager)this.getDirectoryService().getSchemaManager());
        }
        catch (LdapInvalidAttributeTypeException liate) {
            throw new InvalidAttributesException(liate.getMessage());
        }
        if (null == obj) {
            Entry clone = serverEntry.clone();
            try {
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap((Throwable)e);
            }
            return;
        }
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.getEnvironment(), attrs);
        Entry outServerEntry = null;
        try {
            outServerEntry = ServerEntryUtils.toServerEntry((Attributes)res.getAttributes(), (Dn)target, (SchemaManager)this.getDirectoryService().getSchemaManager());
        }
        catch (LdapInvalidAttributeTypeException le) {
            throw new InvalidAttributesException(le.getMessage());
        }
        if (outServerEntry != serverEntry) {
            Entry clone = serverEntry.clone();
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (Attribute attribute : outServerEntry) {
                    try {
                        clone.put(new Attribute[]{attribute});
                    }
                    catch (LdapException ldapException) {}
                }
            }
            try {
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap((Throwable)e);
            }
            return;
        }
        if (obj instanceof Referenceable) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_493, (Object[])new Object[0]));
        }
        if (obj instanceof Reference) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_494, (Object[])new Object[0]));
        }
        if (obj instanceof Serializable) {
            Entry clone = serverEntry.clone();
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (Attribute attribute : outServerEntry) {
                    try {
                        clone.put(new Attribute[]{attribute});
                    }
                    catch (LdapException le) {
                        throw new InvalidAttributesException(le.getMessage());
                    }
                }
            }
            try {
                JavaLdapSupport.serialize(serverEntry, obj, this.getDirectoryService().getSchemaManager());
                this.doAddOperation(target, clone);
            }
            catch (Exception e) {
                JndiUtils.wrap((Throwable)e);
            }
        } else if (obj instanceof DirContext) {
            Entry entry = null;
            try {
                entry = ServerEntryUtils.toServerEntry((Attributes)((DirContext)obj).getAttributes(""), (Dn)target, (SchemaManager)this.getDirectoryService().getSchemaManager());
            }
            catch (LdapInvalidAttributeTypeException liate) {
                throw new InvalidAttributeIdentifierException(liate.getMessage());
            }
            if (outServerEntry != null && outServerEntry.size() > 0) {
                for (Attribute attribute : outServerEntry) {
                    try {
                        entry.put(new Attribute[]{attribute});
                    }
                    catch (LdapException le) {
                        throw new InvalidAttributeValueException(le.getMessage());
                    }
                }
            }
            try {
                this.doAddOperation(target, entry);
            }
            catch (Exception e) {
                JndiUtils.wrap((Throwable)e);
            }
        } else {
            throw new NamingException(I18n.err((I18n)I18n.ERR_495, (Object[])new Object[]{obj}));
        }
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(new LdapName(name), obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        try {
            HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(this.getSession(), target);
            if (this.getDirectoryService().getOperationManager().hasEntry(hasEntryContext)) {
                this.doDeleteOperation(target);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        this.bind(name, obj, AttributeUtils.toCaseInsensitive((Attributes)attrs));
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        Attributes attributes = AttributeUtils.toCaseInsensitive((Attributes)attrs);
        return this.createSubcontext(new LdapName(name), attributes);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (null == attrs) {
            return (DirContext)super.createSubcontext(name);
        }
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        attrs = AttributeUtils.toCaseInsensitive((Attributes)attrs);
        Attributes attributes = (Attributes)attrs.clone();
        try {
            Entry serverEntry = ServerEntryUtils.toServerEntry((Attributes)attributes, (Dn)target, (SchemaManager)this.getDirectoryService().getSchemaManager());
            this.doAddOperation(target, serverEntry);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), JndiUtils.toName((Dn)target));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        return ctx;
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search((Name)new LdapName(name), matchingAttributes, null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), null);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new LdapName(name), AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes), attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        SearchControls ctls = new SearchControls();
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        if (null != attributesToReturn) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        if (null == (matchingAttributes = AttributeUtils.toCaseInsensitive((Attributes)matchingAttributes)) || matchingAttributes.size() <= 0) {
            PresenceNode filter = new PresenceNode(this.objectClassAT);
            AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
            try {
                EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)filter, ctls);
                return new NamingEnumerationAdapter(cursor);
            }
            catch (Exception e) {
                JndiUtils.wrap((Throwable)e);
            }
        }
        if (matchingAttributes.size() == 1) {
            NamingEnumeration<? extends javax.naming.directory.Attribute> list = matchingAttributes.getAll();
            javax.naming.directory.Attribute attr = list.next();
            list.close();
            if (attr.size() == 1) {
                Object value = attr.get();
                String attributeType = attr.getID();
                EqualityNode node = value instanceof byte[] ? new EqualityNode(attributeType, (Value)new BinaryValue((byte[])value)) : new EqualityNode(attributeType, (Value)new StringValue((String)value));
                AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
                try {
                    EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)node, ctls);
                    return new NamingEnumerationAdapter(cursor);
                }
                catch (Exception e) {
                    JndiUtils.wrap((Throwable)e);
                    return null;
                }
            }
        }
        AndNode filter = new AndNode();
        NamingEnumeration<? extends javax.naming.directory.Attribute> list = matchingAttributes.getAll();
        while (list.hasMore()) {
            javax.naming.directory.Attribute attr = list.next();
            if (attr.size() == 0) {
                filter.addNode((ExprNode)new PresenceNode(attr.getID()));
                continue;
            }
            for (int ii = 0; ii < attr.size(); ++ii) {
                Object val = attr.get(ii);
                if (!(val instanceof String)) continue;
                EqualityNode node = new EqualityNode(attr.getID(), (Value)new StringValue((String)val));
                filter.addNode((ExprNode)node);
            }
        }
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, (ExprNode)filter, ctls);
            return new NamingEnumerationAdapter(cursor);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new LdapName(name), filter, cons);
    }

    public NamingEnumeration<SearchResult> search(Name name, ExprNode filter, SearchControls cons) throws NamingException {
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            return new NamingEnumerationAdapter(this.doSearchOperation(target, aliasDerefMode, filter, cons));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        ExprNode filterNode;
        Dn target = this.buildTarget(JndiUtils.fromName((Name)name));
        try {
            filterNode = FilterParser.parse((SchemaManager)this.schemaManager, (String)filter);
        }
        catch (ParseException pe) {
            InvalidSearchFilterException isfe = new InvalidSearchFilterException(I18n.err((I18n)I18n.ERR_500, (Object[])new Object[]{filter}));
            isfe.setRootCause(pe);
            throw isfe;
        }
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            EntryFilteringCursor cursor = this.doSearchOperation(target, aliasDerefMode, filterNode, cons);
            return new NamingEnumerationAdapter(cursor);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
            return null;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(new LdapName(name), filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            int start;
            try {
                while (ii < buf.length() && '{' != buf.charAt(ii)) {
                    ++ii;
                }
                start = ii;
                while ('}' != buf.charAt(ii)) {
                    ++ii;
                }
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            int index = Integer.parseInt(buf.substring(start + 1, ii));
            if (filterArgs[index] instanceof String) {
                buf.replace(start, ii + 1, (String)filterArgs[index]);
                continue;
            }
            if (filterArgs[index] instanceof byte[]) {
                String hexstr = "#" + Strings.toHexString((byte[])((byte[])filterArgs[index]));
                buf.replace(start, ii + 1, hexstr);
                continue;
            }
            buf.replace(start, ii + 1, filterArgs[index].toString());
        }
        return this.search(name, buf.toString(), cons);
    }

    @Override
    public void addNamingListener(Name name, String filterStr, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        ExprNode filter;
        try {
            filter = FilterParser.parse((SchemaManager)this.schemaManager, (String)filterStr);
        }
        catch (Exception e) {
            NamingException e2 = new NamingException(I18n.err((I18n)I18n.ERR_501, (Object[])new Object[]{filterStr}));
            e2.setRootCause(e);
            throw e2;
        }
        try {
            EventListenerAdapter listener = new EventListenerAdapter((ServerLdapContext)this, namingListener);
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setFilter(filter);
            criteria.setScope(SearchScope.getSearchScope((int)searchControls.getSearchScope()));
            criteria.setAliasDerefMode(AliasDerefMode.getEnum(this.getEnvironment()));
            criteria.setBase(this.buildTarget(JndiUtils.fromName((Name)name)));
            this.getDirectoryService().getEventService().addListener((DirectoryListener)listener, criteria);
            this.getListeners().put(namingListener, listener);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
    }

    @Override
    public void addNamingListener(String name, String filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(new LdapName(name), filter, searchControls, namingListener);
    }

    @Override
    public void addNamingListener(Name name, String filterExpr, Object[] filterArgs, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        StringBuffer buf = new StringBuffer(filterExpr);
        for (int ii = 0; ii < buf.length(); ++ii) {
            while ('{' != buf.charAt(ii)) {
                ++ii;
            }
            int start = ii;
            while ('}' != buf.charAt(ii)) {
                ++ii;
            }
            buf.replace(start, ii + 1, filterArgs[ii].toString());
        }
        this.addNamingListener(name, buf.toString(), searchControls, namingListener);
    }

    @Override
    public void addNamingListener(String name, String filter, Object[] objects, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(new LdapName(name), filter, objects, searchControls, namingListener);
    }
}

