/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.Callback;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Context {
    protected Map context = new HashMap();
    protected List callbacks = new ArrayList();

    public Context() {
    }

    public Context(Context cxt) {
        this.setAll(cxt);
    }

    public Context copy() {
        return new Context(this);
    }

    public Object get(Symbol property) {
        return this.context.get(property);
    }

    public Object get(Symbol property, Object defaultValue) {
        Object x = this.context.get(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public void put(Symbol property, Object value) {
        this.context.put(property, value);
        this.doCallbacks(property);
    }

    public void set(Symbol property, Object value) {
        this.context.put(property, value);
        this.doCallbacks(property);
    }

    public void set(Symbol property, boolean value) {
        if (value) {
            this.setTrue(property);
        } else {
            this.setFalse(property);
        }
    }

    public void setIfUndef(Symbol property, Object value) {
        Object x = this.context.get(property);
        if (x == null) {
            this.context.put(property, value);
        }
    }

    public void remove(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public void unset(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public boolean isDefined(Symbol property) {
        return this.context.containsKey(property);
    }

    public boolean isUndef(Symbol property) {
        return !this.isDefined(property);
    }

    public String getAsString(Symbol property) {
        Object x = this.context.get(property);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public void setAll(Context other) {
        this.context.putAll(other.context);
        this.callbacks.addAll(other.callbacks);
    }

    public void setTrue(Symbol property) {
        this.set(property, Boolean.TRUE);
    }

    public void setFalse(Symbol property) {
        this.set(property, Boolean.FALSE);
    }

    public boolean isTrue(Symbol property) {
        return this.isTrue(property, false);
    }

    public boolean isTrueOrUndef(Symbol property) {
        return this.isTrue(property, true);
    }

    private boolean isTrue(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("true")) {
            return true;
        }
        return x.equals(Boolean.TRUE);
    }

    public boolean isFalse(Symbol property) {
        return this.isFalse(property, false);
    }

    public boolean isFalseOrUndef(Symbol property) {
        return this.isFalse(property, true);
    }

    private boolean isFalse(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("false")) {
            return true;
        }
        return x.equals(Boolean.FALSE);
    }

    public boolean hasValue(Symbol property, Object value) {
        Object x = this.get(property);
        if (x == null && value == null) {
            return true;
        }
        if (x == null || value == null) {
            return false;
        }
        return x.equals(value);
    }

    public boolean hasValueAsString(Symbol property, String value) {
        return this.hasValueAsString(property, value, false);
    }

    public boolean hasValueAsString(Symbol property, String value, boolean ignoreCase) {
        String s = this.getAsString(property);
        if (s == null && value == null) {
            return true;
        }
        if (s == null || value == null) {
            return false;
        }
        if (ignoreCase) {
            return s.equalsIgnoreCase(value);
        }
        return s.equals(value);
    }

    public Set keys() {
        return this.context.keySet();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Context)) {
            return false;
        }
        Context cxt = (Context)other;
        return ((Object)this.context).equals(cxt.context);
    }

    public void addCallback(Callback m) {
        this.callbacks.add(m);
    }

    public void removeCallback(Callback m) {
        this.callbacks.remove(m);
    }

    public List getCallbacks() {
        return this.callbacks;
    }

    private void doCallbacks(Symbol symbol) {
        Iterator iter = this.callbacks.iterator();
        while (iter.hasNext()) {
            Callback m = (Callback)iter.next();
            m.event(symbol);
        }
    }

    public String toString() {
        String x = "";
        String sep = "";
        Iterator iter = this.keys().iterator();
        while (iter.hasNext()) {
            Symbol s = (Symbol)iter.next();
            Object value = this.get(s);
            x = x + sep + s + " = " + value;
            sep = "\n";
        }
        return x;
    }
}

