/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.resultset.OutputBase;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.resultset.ResultSetRewindable;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class TextOutput
extends OutputBase {
    protected SerializationContext context = null;
    static final String notThere = " ";

    public TextOutput(Prologue prologue) {
        this.context = new SerializationContext(prologue);
    }

    public TextOutput(PrefixMapping pMap) {
        this.context = new SerializationContext(pMap);
    }

    public TextOutput(SerializationContext cxt) {
        this.context = cxt;
    }

    public void format(OutputStream outs, ResultSet resultSet) {
        this.write(outs, resultSet);
    }

    public void format(Writer w, ResultSet resultSet) {
        PrintWriter pw = new PrintWriter(w);
        this.write(pw, resultSet);
        pw.flush();
    }

    private int[] colWidths(ResultSetRewindable rs) {
        int numCols = rs.getResultVars().size();
        int numRows = 0;
        int[] colWidths = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colWidths[i] = ((String)rs.getResultVars().get(i)).length();
        }
        while (rs.hasNext()) {
            ++numRows;
            QuerySolution rBind = rs.nextSolution();
            int col = -1;
            Iterator iter = rs.getResultVars().iterator();
            while (iter.hasNext()) {
                String rVar = (String)iter.next();
                String s = this.getVarValueAsString(rBind, rVar);
                if (colWidths[++col] >= s.length()) continue;
                colWidths[col] = s.length();
            }
        }
        rs.reset();
        return colWidths;
    }

    public void write(PrintWriter pw, ResultSet resultSet) {
        this.write(pw, resultSet, "| ", " | ", " |");
    }

    public void write(OutputStream outs, ResultSet resultSet) {
        this.write(outs, resultSet, "| ", " | ", " |");
    }

    public void write(OutputStream outs, ResultSet resultSet, String colStart, String colSep, String colEnd) {
        PrintWriter pw = FileUtils.asPrintWriterUTF8((OutputStream)outs);
        this.write(pw, resultSet, colStart, colSep, colEnd);
        pw.flush();
    }

    public void write(PrintWriter pw, ResultSet resultSet, String colStart, String colSep, String colEnd) {
        int i;
        if (resultSet.getResultVars().size() == 0) {
            pw.println("==== No variables ====");
            return;
        }
        ResultSetMem resultSetRewindable = new ResultSetMem(resultSet);
        int numCols = resultSetRewindable.getResultVars().size();
        int[] colWidths = this.colWidths(resultSetRewindable);
        String[] row = new String[numCols];
        int lineWidth = 0;
        for (int col = 0; col < numCols; ++col) {
            String rVar;
            row[col] = rVar = (String)resultSet.getResultVars().get(col);
            lineWidth += colWidths[col];
            if (col <= 0) continue;
            lineWidth += colSep.length();
        }
        if (colStart != null) {
            lineWidth += colStart.length();
        }
        if (colEnd != null) {
            lineWidth += colEnd.length();
        }
        for (i = 0; i < lineWidth; ++i) {
            pw.print('-');
        }
        pw.println();
        this.printRow(pw, row, colWidths, colStart, colSep, colEnd);
        for (i = 0; i < lineWidth; ++i) {
            pw.print('=');
        }
        pw.println();
        while (resultSetRewindable.hasNext()) {
            QuerySolution rBind = resultSetRewindable.nextSolution();
            for (int col = 0; col < numCols; ++col) {
                String rVar = (String)resultSet.getResultVars().get(col);
                row[col] = this.getVarValueAsString(rBind, rVar);
            }
            this.printRow(pw, row, colWidths, colStart, colSep, colEnd);
        }
        for (i = 0; i < lineWidth; ++i) {
            pw.print('-');
        }
        pw.println();
        resultSetRewindable = null;
    }

    private void printRow(PrintWriter out, String[] row, int[] colWidths, String rowStart, String colSep, String rowEnd) {
        out.print(rowStart);
        for (int col = 0; col < colWidths.length; ++col) {
            String s = row[col];
            int pad = colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(colSep);
            }
            sbuff.append(s);
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            out.print(sbuff);
        }
        out.print(rowEnd);
        out.println();
    }

    private String getVarValueAsString(QuerySolution rBind, String varName) {
        RDFNode obj = rBind.get(varName);
        if (obj == null) {
            return notThere;
        }
        return FmtUtils.stringForRDFNode(obj, this.context);
    }

    public void format(OutputStream out, boolean answer) {
        PrintWriter pw = FileUtils.asPrintWriterUTF8((OutputStream)out);
        if (answer) {
            pw.write("yes");
        } else {
            pw.write("no");
        }
        pw.flush();
    }
}

