/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.Utils;

public class SortCondition
extends PrintSerializableBase {
    public Expr expression = null;
    public int direction = 0;

    public SortCondition(Var var, int dir) {
        this(new ExprVar(var), dir);
    }

    public SortCondition(Node var, int dir) {
        this(ExprUtils.nodeToExpr(var), dir);
    }

    public SortCondition(Expr expr, int dir) {
        this.expression = expr;
        this.direction = dir;
        if (dir != Query.ORDER_ASCENDING && dir != Query.ORDER_DESCENDING && dir != Query.ORDER_DEFAULT) {
            ALog.fatal(this, "Unknown sort direction");
        }
    }

    public void format(FmtExpr fmt, IndentedWriter writer) {
        boolean explicitDirection = false;
        boolean needParens = false;
        if (this.direction != Query.ORDER_DEFAULT && (this.expression.isVariable() || this.expression instanceof E_Function)) {
            needParens = true;
        }
        if (this.direction == Query.ORDER_ASCENDING) {
            writer.print("ASC");
        }
        if (this.direction == Query.ORDER_DESCENDING) {
            writer.print("DESC");
        }
        if (needParens) {
            writer.print("(");
        }
        fmt.format(this.expression);
        if (needParens) {
            writer.print(")");
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Expr getExpression() {
        return this.expression;
    }

    public int hashCode() {
        int x = this.getDirection();
        if (this.getExpression() != null) {
            x ^= this.getExpression().hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SortCondition)) {
            return false;
        }
        SortCondition sc = (SortCondition)other;
        if (sc.getDirection() != this.getDirection()) {
            return false;
        }
        return Utils.eq(this.getExpression(), sc.getExpression());
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        FmtExprARQ fmt = new FmtExprARQ(out, sCxt);
        this.format(fmt, out);
    }
}

