/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.test.apache.directory.server.integ;

import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.log4j.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class ApacheDSSuiteRunner
extends Suite {
    static Logger logger = Logger.getLogger(ApacheDSSuiteRunner.class);
    private static final String SET_SERVICE_METHOD_NAME = "setService";
    private static final String SET_LDAP_SERVER_METHOD_NAME = "setLdapServer";
    private static final String SET_KDC_SERVER_METHOD_NAME = "setKdcServer";
    private DirectoryService classDS = null;
    private static LdapServer classLdapServer = null;
    private KdcServer classKdcServer = null;

    public ApacheDSSuiteRunner(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
    }

    public ApacheDSSuiteRunner(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
        super(builder, (Class[])classes);
    }

    protected ApacheDSSuiteRunner(Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(klass, (Class[])suiteClasses);
    }

    protected ApacheDSSuiteRunner(RunnerBuilder builder, Class<?> klass, Class<?>[] suiteClasses) throws InitializationError {
        super(builder, klass, (Class[])suiteClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        CreateLdapServer classLdapServerBuilder = (CreateLdapServer)this.getDescription().getAnnotation(CreateLdapServer.class);
        try {
            this.classDS = DSAnnotationProcessor.getDirectoryService((Description)this.getDescription());
            long revision = 0L;
            DirectoryService directoryService = null;
            if (this.classDS != null && this.classDS.isStarted()) {
                directoryService = this.classDS;
                DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)this.classDS);
            } else {
                DirectoryServiceFactory dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                directoryService = dsf.getDirectoryService();
                directoryService.getChangeLog().setEnabled(true);
                dsf.init("default" + UUID.randomUUID().toString());
                this.classDS = directoryService;
                DSAnnotationProcessor.loadSchemas((Description)this.getDescription(), (DirectoryService)directoryService);
                DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)directoryService);
            }
            if (classLdapServerBuilder != null) {
                classLdapServer = ServerAnnotationProcessor.createLdapServer((Description)this.getDescription(), (DirectoryService)directoryService);
            }
            if (this.classKdcServer == null) {
                int minPort = this.getMinPort();
                this.classKdcServer = ServerAnnotationProcessor.getKdcServer((Description)this.getDescription(), (DirectoryService)directoryService, (int)(minPort + 1));
            }
            DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
            PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
            logger.debug((Object)("Using partition factory " + partitionFactory.getClass().getSimpleName()));
            super.run(notifier);
            if (classLdapServer != null) {
                classLdapServer.stop();
            }
            if (this.classKdcServer != null) {
                this.classKdcServer.stop();
            }
            if (this.classDS != null) {
                logger.debug((Object)("Shuting down DS for " + this.classDS.getInstanceId()));
                this.classDS.shutdown();
                FileUtils.deleteDirectory((File)this.classDS.getInstanceLayout().getInstanceDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18n.err((I18n)I18n.ERR_181, (Object[])new Object[]{this.getTestClass().getName()}));
            logger.error((Object)e.getLocalizedMessage());
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
        finally {
            this.classDS = null;
            classLdapServer = null;
            this.classKdcServer = null;
        }
    }

    private int getMinPort() {
        int minPort = 0;
        return minPort;
    }

    private long getCurrentRevision(DirectoryService dirService) throws Exception {
        if (dirService != null && dirService.getChangeLog().isEnabled()) {
            long revision = dirService.getChangeLog().getCurrentRevision();
            logger.debug((Object)("Create revision " + revision));
            return revision;
        }
        return 0L;
    }

    private void revert(DirectoryService dirService, long revision) throws Exception {
        if (dirService == null) {
            return;
        }
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            logger.debug((Object)("Revert revision " + revision));
            dirService.revert(revision);
        }
    }

    public static LdapServer getLdapServer() {
        return classLdapServer;
    }
}

