/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import java.util.Collection;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ModifyRequestDsml
extends AbstractResultResponseRequestDsml<ModifyRequest, ModifyResponse>
implements ModifyRequest {
    private Attribute currentAttribute;
    private ModificationOperation currentOperation;

    public ModifyRequestDsml(LdapApiService codec) {
        super(codec, new ModifyRequestImpl());
    }

    public ModifyRequestDsml(LdapApiService codec, ModifyRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation((int)currentOperation);
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultAttribute(type);
        DefaultModification modification = new DefaultModification(this.currentOperation, this.currentAttribute);
        ((ModifyRequest)this.getDecorated()).addModification((Modification)modification);
    }

    public void addAttributeValue(byte[] value) throws LdapException {
        this.currentAttribute.add((byte[][])new byte[][]{value});
    }

    public void addAttributeValue(String value) throws LdapException {
        this.currentAttribute.add(new String[]{value});
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ModifyRequest request = (ModifyRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        Collection modifications = request.getModifications();
        for (Modification modification : modifications) {
            ModificationOperation operation;
            Element modElement = element.addElement("modification");
            if (modification.getAttribute() != null) {
                modElement.addAttribute("name", modification.getAttribute().getId());
                for (Value value : modification.getAttribute()) {
                    if (value.getValue() == null) continue;
                    if (ParserUtils.needsBase64Encoding(value.getValue())) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        element.getDocument().getRootElement().add(xsdNamespace);
                        element.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = modElement.addElement("value").addText(ParserUtils.base64Encode(value.getValue()));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                        continue;
                    }
                    modElement.addElement("value").setText(value.getString());
                }
            }
            if ((operation = modification.getOperation()) == ModificationOperation.ADD_ATTRIBUTE) {
                modElement.addAttribute("operation", "add");
                continue;
            }
            if (operation == ModificationOperation.REPLACE_ATTRIBUTE) {
                modElement.addAttribute("operation", "replace");
                continue;
            }
            if (operation != ModificationOperation.REMOVE_ATTRIBUTE) continue;
            modElement.addAttribute("operation", "delete");
        }
        return element;
    }

    public MessageTypeEnum getResponseType() {
        return ((ModifyRequest)this.getDecorated()).getResponseType();
    }

    public Dn getName() {
        return ((ModifyRequest)this.getDecorated()).getName();
    }

    public ModifyRequest setName(Dn name) {
        ((ModifyRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Collection<Modification> getModifications() {
        return ((ModifyRequest)this.getDecorated()).getModifications();
    }

    public ModifyRequest addModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).addModification(mod);
        return this;
    }

    public ModifyRequest removeModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).removeModification(mod);
        return this;
    }

    public ModifyRequest remove(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest remove(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest remove(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).remove(attr);
        return this;
    }

    public ModifyRequest remove(String attributeName) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName);
        return this;
    }

    public ModifyRequest addModification(Attribute attr, ModificationOperation modOp) {
        ((ModifyRequest)this.getDecorated()).addModification(attr, modOp);
        return this;
    }

    public ModifyRequest add(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest add(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest add(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).add(attr);
        return this;
    }

    public ModifyRequest replace(String attributeName) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName);
        return this;
    }

    public ModifyRequest replace(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest replace(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest replace(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).replace(attr);
        return this;
    }

    public ModifyRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ModifyRequest addControl(Control control) {
        return (ModifyRequest)super.addControl(control);
    }

    public ModifyRequest addAllControls(Control[] controls) {
        return (ModifyRequest)super.addAllControls(controls);
    }

    public ModifyRequest removeControl(Control control) {
        return (ModifyRequest)super.removeControl(control);
    }
}

