/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.version.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class VerGen {
    private static final String PACKAGE_NAME = "org.apache.zookeeper.version";
    private static final String TYPE_NAME = "Info";

    static void printUsage() {
        System.out.print("Usage:\tjava  -cp <classpath> org.apache.zookeeper.version.util.VerGen maj.min.micro rev buildDate");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateFile(File outputDir, int maj, int min, int micro, int rev, String buildDate) {
        String path = PACKAGE_NAME.replaceAll("\\.", "/");
        File pkgdir = new File(outputDir, path);
        if (!pkgdir.exists()) {
            boolean ret = pkgdir.mkdirs();
            if (!ret) {
                System.out.println("Cannnot create directory: " + path);
                System.exit(1);
            }
        } else if (!pkgdir.isDirectory()) {
            System.out.println(path + " is not a directory.");
            System.exit(1);
        }
        File file = new File(pkgdir, "Info.java");
        FileWriter w = null;
        try {
            w = new FileWriter(file);
            w.write("// Do not edit!\n// File generated by org.apache.zookeeper.version.util.VerGen.\n");
            w.write("/**\n");
            w.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
            w.write("* or more contributor license agreements.  See the NOTICE file\n");
            w.write("* distributed with this work for additional information\n");
            w.write("* regarding copyright ownership.  The ASF licenses this file\n");
            w.write("* to you under the Apache License, Version 2.0 (the\n");
            w.write("* \"License\"); you may not use this file except in compliance\n");
            w.write("* with the License.  You may obtain a copy of the License at\n");
            w.write("*\n");
            w.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
            w.write("*\n");
            w.write("* Unless required by applicable law or agreed to in writing, software\n");
            w.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
            w.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
            w.write("* See the License for the specific language governing permissions and\n");
            w.write("* limitations under the License.\n");
            w.write("*/\n");
            w.write("\n");
            w.write("package org.apache.zookeeper.version;\n\n");
            w.write("public interface Info {\n");
            w.write("    public static final int MAJOR=" + maj + ";\n");
            w.write("    public static final int MINOR=" + min + ";\n");
            w.write("    public static final int MICRO=" + micro + ";\n");
            if (rev < 0) {
                System.out.println("Unknown REVISION number, using " + rev);
            }
            w.write("    public static final int REVISION=" + rev + ";\n");
            w.write("    public static final String BUILD_DATE=\"" + buildDate + "\";\n");
            w.write("}\n");
        }
        catch (IOException e) {
            System.out.println("Unable to generate version.Info file: " + e.getMessage());
            System.exit(1);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    System.out.println("Unable to close file writer" + e.getMessage());
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            VerGen.printUsage();
        }
        try {
            int rev;
            String[] v = args[0].split("\\.");
            if (v.length != 3) {
                System.err.println("Invalid version number format, must be \"x.y.z\"");
                System.exit(1);
            }
            int maj = Integer.parseInt(v[0]);
            int min = Integer.parseInt(v[1]);
            int micro = Integer.parseInt(v[2]);
            try {
                rev = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                rev = -1;
            }
            VerGen.generateFile(new File("."), maj, min, micro, rev, args[2]);
        }
        catch (NumberFormatException e) {
            System.err.println("All version-related parameters must be valid integers!");
            throw e;
        }
    }
}

