/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.hash;

import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;

public abstract class PasswordHashingInterceptor
extends BaseInterceptor {
    private LdapSecurityConstants algorithm;

    protected PasswordHashingInterceptor(String name, LdapSecurityConstants algorithm) {
        super(name);
        this.algorithm = algorithm;
    }

    public void add(AddOperationContext addContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(addContext);
            return;
        }
        Entry entry = addContext.getEntry();
        Attribute pwdAt = entry.get("userPassword");
        Attribute hashedPwdAt = this.includeHashedPassword(pwdAt);
        if (hashedPwdAt != null) {
            entry.remove(new Attribute[]{pwdAt});
            entry.add(new Attribute[]{hashedPwdAt});
        }
        this.next(addContext);
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(modifyContext);
            return;
        }
        List mods = modifyContext.getModItems();
        for (Modification mod : mods) {
            Attribute newPwd;
            String oid = mod.getAttribute().getAttributeType().getOid();
            if (!"2.5.4.35".equals(oid) || mod.getOperation() == ModificationOperation.REMOVE_ATTRIBUTE || (newPwd = this.includeHashedPassword(mod.getAttribute())) == null) continue;
            mod.setAttribute(newPwd);
        }
        this.next(modifyContext);
    }

    private Attribute includeHashedPassword(Attribute pwdAt) throws LdapException {
        if (pwdAt == null) {
            return null;
        }
        DefaultAttribute newPwd = new DefaultAttribute(pwdAt.getAttributeType());
        for (Value userPassword : pwdAt) {
            if (userPassword.getValue() == null) continue;
            LdapSecurityConstants existingAlgo = PasswordUtil.findAlgorithm((byte[])((BinaryValue)userPassword).getValue());
            if (existingAlgo == null) {
                byte[] hashedPassword = PasswordUtil.createStoragePassword((byte[])((BinaryValue)userPassword).getValue(), (LdapSecurityConstants)this.algorithm);
                newPwd.add((byte[][])new byte[][]{hashedPassword});
                continue;
            }
            newPwd.add((byte[][])new byte[][]{((BinaryValue)userPassword).getValue()});
        }
        return newPwd;
    }
}

