/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.portal;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.util.DateTimeMarshaller;

public class TokenGenerator {
    public static Log log = LogFactory.getLog(TokenGenerator.class);
    private static TokenGenerator instance = null;
    private String consumerKey = null;
    private RSAPublicKey publicKey = null;
    private RSAPrivateKey privateKey = null;
    private int TTL_SECONDS = Settings.getConfiguration().getInt("token.ttl", 64800);

    public static TokenGenerator getInstance() throws IOException {
        if (instance == null) {
            instance = new TokenGenerator();
        }
        return instance;
    }

    private TokenGenerator() throws IOException {
        String privateKeyFileName = Settings.getConfiguration().getString("cn.server.privatekey.filename");
        String privateKeyPassword = null;
        CertificateManager cmInst = CertificateManager.getInstance();
        if (privateKeyFileName != null) {
            this.privateKey = (RSAPrivateKey)cmInst.loadPrivateKeyFromFile(privateKeyFileName, privateKeyPassword);
        }
        this.consumerKey = Settings.getConfiguration().getString("annotator.consumerKey");
        String certificateFileName = Settings.getConfiguration().getString("cn.server.publiccert.filename");
        log.debug((Object)("certificateFileName=" + certificateFileName));
        if (certificateFileName != null && certificateFileName.length() > 0) {
            this.publicKey = (RSAPublicKey)cmInst.loadCertificateFromFile(certificateFileName).getPublicKey();
        } else {
            Certificate cert = this.fetchServerCertificate();
            log.debug((Object)("using certificate from server: " + cert));
            if (cert != null) {
                this.publicKey = (RSAPublicKey)cert.getPublicKey();
            }
        }
    }

    public Certificate fetchServerCertificate() {
        try {
            String baseUrl = D1Client.getCN().getNodeBaseServiceUrl();
            log.debug((Object)("fetching cert from server: " + baseUrl));
            URL url = new URL(baseUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            Certificate serverCertificate = conn.getServerCertificates()[0];
            return serverCertificate;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getJWT(String userId, String fullName) throws JOSEException, ParseException, IOException {
        RSASSASigner signer = new RSASSASigner(this.privateKey);
        Calendar now = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        expires.setTime(now.getTime());
        expires.add(13, this.TTL_SECONDS);
        JWTClaimsSet claimsSet = new JWTClaimsSet();
        claimsSet.setClaim("consumerKey", (Object)this.consumerKey);
        claimsSet.setClaim("userId", (Object)userId);
        claimsSet.setClaim("issuedAt", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now.getTime()));
        claimsSet.setClaim("ttl", (Object)this.TTL_SECONDS);
        claimsSet.setClaim("fullName", (Object)fullName);
        claimsSet.setSubject(userId);
        claimsSet.setIssueTime(now.getTime());
        claimsSet.setExpirationTime(expires.getTime());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), (ReadOnlyJWTClaimsSet)claimsSet);
        signedJWT.sign((JWSSigner)signer);
        String token = signedJWT.serialize();
        return token;
    }

    public Session getSession(String token) {
        AuthTokenSession session = null;
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            RSASSAVerifier verifier = new RSASSAVerifier(this.publicKey);
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                log.info((Object)("public key: " + this.publicKey));
                log.warn((Object)("Could not use public key to verify provided token: " + token));
                return null;
            }
            Calendar now = Calendar.getInstance();
            Date expDate = signedJWT.getJWTClaimsSet().getExpirationTime();
            if (!expDate.after(now.getTime())) {
                log.warn((Object)("Token expiration date has passed: " + expDate));
                return null;
            }
            String userId = signedJWT.getJWTClaimsSet().getSubject();
            Subject subject = new Subject();
            subject.setValue(userId);
            session = new AuthTokenSession(token);
            session.setSubject(subject);
            SubjectInfo subjectInfo = null;
            try {
                subjectInfo = D1Client.getCN().getSubjectInfo(subject);
            }
            catch (Exception be) {
                log.warn((Object)be.getMessage(), (Throwable)be);
            }
            if (subjectInfo == null) {
                subjectInfo = new SubjectInfo();
                Person person = new Person();
                person.setSubject(subject);
                person.setFamilyName("Unknown");
                person.addGivenName("Unknown");
                subjectInfo.setPersonList(Arrays.asList(person));
            }
            session.setSubjectInfo(subjectInfo);
        }
        catch (Exception e) {
            log.warn((Object)("Could not get session from provided token: " + token), (Throwable)e);
            return null;
        }
        return session;
    }

    public static void main(String[] args) {
        String userId = args[0];
        String fullName = "Unknown";
        if (args.length > 1) {
            fullName = args[1];
        }
        String token = null;
        try {
            token = TokenGenerator.getInstance().getJWT(userId, fullName);
        }
        catch (JOSEException | IOException | ParseException e) {
            e.printStackTrace();
        }
        System.out.println(token);
    }
}

