/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.net.URISyntaxException;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREResource;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.Triple;

public class TripleJena
implements Triple {
    Model model = ModelFactory.createDefaultModel();
    Resource triple;

    public void initialise(URI uri) {
        this.triple = this.model.createResource(uri.toString());
    }

    public void initialise(OREResource resource) throws OREException {
        this.triple = this.model.createResource(resource.getURI().toString());
    }

    public void relate(Predicate pred, URI uri) throws OREException {
        Property property = this.model.createProperty(pred.getURI().toString());
        this.triple.addProperty(property, (RDFNode)this.model.createResource(uri.toString()));
    }

    public void relate(Predicate pred, OREResource resource) throws OREException {
        Property property = this.model.createProperty(pred.getURI().toString());
        this.triple.addProperty(property, (RDFNode)this.model.createResource(resource.getURI().toString()));
    }

    public void relate(Predicate pred, Object literal) throws OREException {
        Property property = this.model.createProperty(pred.getURI().toString());
        this.triple.addProperty(property, (RDFNode)this.model.createTypedLiteral(literal));
    }

    public OREResource getSubject() {
        return null;
    }

    public URI getSubjectURI() throws OREException {
        try {
            return new URI(this.triple.getURI());
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    public Predicate getPredicate() throws OREException {
        try {
            StmtIterator itr = this.triple.listProperties();
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Property property = statement.getPredicate();
                Predicate pred = new Predicate();
                pred.setURI(new URI(property.getURI()));
                return pred;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    public OREResource getObject() {
        return null;
    }

    public URI getObjectURI() throws OREException {
        try {
            StmtIterator itr = this.triple.listProperties();
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                RDFNode node = statement.getObject();
                if (node instanceof Literal) {
                    throw new OREException("Cannot get URI; object is Literal");
                }
                return new URI(((Resource)node).getURI());
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    public String getObjectLiteral() throws OREException {
        StmtIterator itr = this.triple.listProperties();
        if (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            RDFNode node = statement.getObject();
            if (node instanceof Resource) {
                throw new OREException("Cannot get Literal; object is a Resource");
            }
            return ((Literal)node).getLexicalForm();
        }
        return null;
    }

    public String getLiteralType() throws OREException {
        StmtIterator itr = this.triple.listProperties();
        if (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            RDFNode node = statement.getObject();
            if (node instanceof Resource) {
                throw new OREException("Cannot get Literal type; object is a Resource");
            }
            return ((Literal)node).getDatatypeURI();
        }
        return null;
    }

    public boolean isLiteral() {
        StmtIterator itr = this.triple.listProperties();
        if (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            RDFNode node = statement.getObject();
            return !(node instanceof Resource);
        }
        return false;
    }
}

