/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.ListCursor;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.changelog.ChangeLogEvent;
import org.apache.directory.server.core.api.changelog.ChangeLogEventSerializer;
import org.apache.directory.server.core.api.changelog.Tag;
import org.apache.directory.server.core.api.changelog.TaggableChangeLogStore;
import org.apache.directory.server.i18n.I18n;

public class MemoryChangeLogStore
implements TaggableChangeLogStore {
    private static final String REV_FILE = "revision";
    private static final String TAG_FILE = "tags";
    private static final String CHANGELOG_FILE = "changelog.dat";
    private long currentRevision;
    private Tag latest;
    private final Map<Long, Tag> tags = new HashMap<Long, Tag>(100);
    private final List<ChangeLogEvent> events = new ArrayList<ChangeLogEvent>();
    private File workingDirectory;
    private DirectoryService directoryService;

    public Tag tag(long revision) throws Exception {
        if (this.tags.containsKey(revision)) {
            return this.tags.get(revision);
        }
        this.latest = new Tag(revision, null);
        this.tags.put(revision, this.latest);
        return this.latest;
    }

    public Tag tag() throws Exception {
        if (this.latest != null && this.latest.getRevision() == this.currentRevision) {
            return this.latest;
        }
        this.latest = new Tag(this.currentRevision, null);
        this.tags.put(this.currentRevision, this.latest);
        return this.latest;
    }

    public Tag tag(String description) throws Exception {
        if (this.latest != null && this.latest.getRevision() == this.currentRevision) {
            return this.latest;
        }
        this.latest = new Tag(this.currentRevision, description);
        this.tags.put(this.currentRevision, this.latest);
        return this.latest;
    }

    public void init(DirectoryService service) throws Exception {
        this.workingDirectory = service.getInstanceLayout().getLogDirectory();
        this.directoryService = service;
        this.loadRevision();
        this.loadTags();
        this.loadChangeLog();
    }

    private void loadRevision() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(revFile));
                String line = reader.readLine();
                this.currentRevision = Long.valueOf(line);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveRevision() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists() && !revFile.delete()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_726_FILE_UNDELETABLE, (Object[])new Object[]{revFile.getAbsolutePath()}));
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(revFile));){
            out.println(this.currentRevision);
            out.flush();
        }
    }

    private void saveTags() throws Exception {
        File tagFile = new File(this.workingDirectory, TAG_FILE);
        if (tagFile.exists() && !tagFile.delete()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_726_FILE_UNDELETABLE, (Object[])new Object[]{tagFile.getAbsolutePath()}));
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tagFile);
            Properties props = new Properties();
            for (Tag tag : this.tags.values()) {
                String key = String.valueOf(tag.getRevision());
                if (tag.getDescription() == null) {
                    props.setProperty(key, "null");
                    continue;
                }
                props.setProperty(key, tag.getDescription());
            }
            props.store(out, null);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadTags() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists()) {
            Properties props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(revFile);
                props.load(in);
                ArrayList<Long> revList = new ArrayList<Long>();
                for (Object key : props.keySet()) {
                    revList.add(Long.valueOf((String)key));
                }
                Collections.sort(revList);
                Tag tag = null;
                this.tags.clear();
                for (Long lkey : revList) {
                    String rev = String.valueOf(lkey);
                    String desc = props.getProperty(rev);
                    tag = desc != null && desc.equals("null") ? new Tag(lkey.longValue(), null) : new Tag(lkey.longValue(), desc);
                    this.tags.put(lkey, tag);
                }
                this.latest = tag;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadChangeLog() throws Exception {
        File file = new File(this.workingDirectory, CHANGELOG_FILE);
        if (file.exists()) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(file));
                int size = in.readInt();
                ArrayList<ChangeLogEvent> changeLogEvents = new ArrayList<ChangeLogEvent>(size);
                for (int i = 0; i < size; ++i) {
                    ChangeLogEvent event = ChangeLogEventSerializer.deserialize((SchemaManager)this.directoryService.getSchemaManager(), (ObjectInput)in);
                    event.getCommitterPrincipal().setSchemaManager(this.directoryService.getSchemaManager());
                    changeLogEvents.add(event);
                }
                this.events.clear();
                this.events.addAll(changeLogEvents);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveChangeLog() throws Exception {
        File file = new File(this.workingDirectory, CHANGELOG_FILE);
        if (file.exists() && !file.delete()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_726_FILE_UNDELETABLE, (Object[])new Object[]{file.getAbsolutePath()}));
        }
        file.createNewFile();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeInt(this.events.size());
            for (ChangeLogEvent event : this.events) {
                ChangeLogEventSerializer.serialize((ChangeLogEvent)event, (ObjectOutput)out);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void sync() throws Exception {
        this.saveRevision();
        this.saveTags();
        this.saveChangeLog();
    }

    public void destroy() throws Exception {
        this.saveRevision();
        this.saveTags();
        this.saveChangeLog();
    }

    public long getCurrentRevision() {
        return this.currentRevision;
    }

    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, LdifEntry reverse) throws Exception {
        ++this.currentRevision;
        ChangeLogEvent event = new ChangeLogEvent(this.currentRevision, DateUtils.getGeneralizedTime(), principal, forward, reverse);
        this.events.add(event);
        return event;
    }

    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, List<LdifEntry> reverses) throws Exception {
        ++this.currentRevision;
        ChangeLogEvent event = new ChangeLogEvent(this.currentRevision, DateUtils.getGeneralizedTime(), principal, forward, reverses);
        this.events.add(event);
        return event;
    }

    public ChangeLogEvent lookup(long revision) throws Exception {
        if (revision < 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_239, (Object[])new Object[0]));
        }
        if (revision > this.getCurrentRevision()) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_240, (Object[])new Object[0]));
        }
        return this.events.get((int)revision);
    }

    public Cursor<ChangeLogEvent> find() throws Exception {
        return new ListCursor(this.events);
    }

    public Cursor<ChangeLogEvent> findBefore(long revision) throws Exception {
        return new ListCursor(this.events, (int)revision);
    }

    public Cursor<ChangeLogEvent> findAfter(long revision) throws LdapException {
        return new ListCursor((int)revision, this.events);
    }

    public Cursor<ChangeLogEvent> find(long startRevision, long endRevision) throws Exception {
        return new ListCursor((int)startRevision, this.events, (int)(endRevision + 1L));
    }

    public Tag getLatest() throws LdapException {
        return this.latest;
    }

    public Tag removeTag(long revision) throws Exception {
        return this.tags.remove(revision);
    }

    public Tag tag(long revision, String descrition) throws Exception {
        if (this.tags.containsKey(revision)) {
            return this.tags.get(revision);
        }
        this.latest = new Tag(revision, descrition);
        this.tags.put(revision, this.latest);
        return this.latest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MemoryChangeLog\n");
        sb.append("latest tag : ").append(this.latest).append('\n');
        if (this.events != null) {
            sb.append("Nb of events : ").append(this.events.size()).append('\n');
            int i = 0;
            for (ChangeLogEvent event : this.events) {
                sb.append("event[").append(i++).append("] : ");
                sb.append("\n---------------------------------------\n");
                sb.append(event);
                sb.append("\n---------------------------------------\n");
            }
        }
        return sb.toString();
    }
}

