/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.exception.ClassNotSupported;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import edu.ucsb.nceas.osti_elink.v1.OSTIService;
import edu.ucsb.nceas.osti_elink.v2.xml.OSTIv2XmlService;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSTIServiceFactory {
    public static final String OSTISERVICE_CLASS_NAME = "ostiService_className";
    private static final Log log = LogFactory.getLog(OSTIServiceFactory.class);

    public static OSTIElinkService getOSTIElinkService(Properties properties) throws IllegalArgumentException, PropertyNotFound, ClassNotFoundException, ClassNotSupported, IOException, OSTIElinkException {
        OSTIElinkService service;
        String className = System.getenv(OSTISERVICE_CLASS_NAME);
        if (className == null) {
            try {
                className = OSTIServiceFactory.getProperty(OSTISERVICE_CLASS_NAME, properties);
                log.info((Object)("The class name " + className + " is set by the property file "));
            }
            catch (PropertyNotFound e) {
                log.info((Object)"We cannot find the ostiService_className in neither the evn variable nor the properties file. So we will use the default one: edu.ucsb.nceas.osti_elink.v1.OSTIService");
                className = "edu.ucsb.nceas.osti_elink.v1.OSTIService";
            }
        } else {
            log.info((Object)("The class name " + className + " is set by the environmental variable " + OSTISERVICE_CLASS_NAME));
        }
        String baseURL = OSTIServiceFactory.getProperty("guid_doi_baseurl", properties);
        if (className.equals("edu.ucsb.nceas.osti_elink.v1.OSTIService")) {
            String userName = OSTIServiceFactory.getProperty("guid.doi.username", properties);
            String password = OSTIServiceFactory.getProperty("guid.doi.password", properties);
            service = new OSTIService(userName, password, baseURL);
            log.info((Object)("The OSTI service class is v1: " + service.getClass().getName()));
        } else if (className.equals("edu.ucsb.nceas.osti_elink.v2.xml.OSTIv2XmlService")) {
            service = new OSTIv2XmlService(null, null, baseURL, properties);
            log.info((Object)("The OSTI service class is v2xml: " + service.getClass().getName()));
        } else {
            throw new ClassNotSupported("OSTIService does not support the class " + className);
        }
        return service;
    }

    public static String getProperty(String propertyName, Properties properties) throws IllegalArgumentException, PropertyNotFound {
        if (propertyName == null || propertyName.trim().equals("")) {
            throw new IllegalArgumentException("The propertyName should not be null or blank in the getProperty method.");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("The parameter properties should not be null or blank in the getProperty method.");
        }
        String value = properties.getProperty(propertyName);
        if (value == null || value.trim().equals("")) {
            throw new PropertyNotFound("The poperty of " + propertyName + " can't found");
        }
        return value;
    }
}

