/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.ModelAssembler;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class UnionModelAssembler
extends ModelAssembler
implements Assembler {
    @Override
    protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.UnionModel);
        MultiUnion union = new MultiUnion();
        union.addGraph(this.getRootModel(a, root, mode));
        this.addSubModels(a, root, union, mode);
        return ModelFactory.createModelForGraph(union);
    }

    private Graph getRootModel(Assembler a, Resource root, Mode mode) {
        Resource r = UnionModelAssembler.getUniqueResource(root, JA.rootModel);
        return r == null ? Factory.empty() : a.openModel(r, mode).getGraph();
    }

    private void addSubModels(Assembler a, Resource root, MultiUnion union, Mode mode) {
        StmtIterator it = root.listProperties(JA.subModel);
        while (it.hasNext()) {
            Resource resource = UnionModelAssembler.getResource(it.nextStatement());
            union.addGraph(a.openModel(resource, mode).getGraph());
        }
    }
}

