/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateProcessRemoteBase
implements UpdateProcessor {
    private static Logger log = LoggerFactory.getLogger(UpdateProcessRemoteBase.class);
    public static final Symbol HTTP_CONTEXT = Symbol.create("httpContext");
    private final UpdateRequest request;
    private final String endpoint;
    private final Context context;
    private HttpAuthenticator authenticator;
    private Params params;
    protected List<String> defaultGraphURIs = new ArrayList<String>();
    protected List<String> namedGraphURIs = new ArrayList<String>();

    public UpdateProcessRemoteBase(UpdateRequest request, String endpoint, Context context) {
        this.request = request;
        this.endpoint = endpoint;
        this.context = Context.setupContext(context, null);
        UpdateProcessRemoteBase.applyServiceConfig(endpoint, this);
    }

    private static void applyServiceConfig(String serviceURI, UpdateProcessRemoteBase engine) {
        Map serviceContextMap = (Map)engine.context.get(Service.serviceContext);
        if (serviceContextMap != null && serviceContextMap.containsKey(serviceURI)) {
            Context serviceContext = (Context)serviceContextMap.get(serviceURI);
            if (log.isDebugEnabled()) {
                log.debug("Endpoint URI {} has SERVICE Context: {} ", (Object)serviceURI, (Object)serviceContext);
            }
            String user = serviceContext.getAsString(Service.queryAuthUser);
            String pwd = serviceContext.getAsString(Service.queryAuthPwd);
            if (user != null || pwd != null) {
                user = user == null ? "" : user;
                String string = pwd = pwd == null ? "" : pwd;
                if (log.isDebugEnabled()) {
                    log.debug("Setting basic HTTP authentication for endpoint URI {} with username: {} ", (Object)serviceURI, (Object)user);
                }
                engine.setAuthentication(user, pwd.toCharArray());
            }
        }
    }

    @Override
    public GraphStore getGraphStore() {
        return null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getQueryString() {
        return this.getParams().httpString();
    }

    public Params getParams() {
        Params ps;
        Params params = ps = this.params != null ? new Params(this.params) : new Params();
        if (this.defaultGraphURIs != null) {
            for (String defaultGraph : this.defaultGraphURIs) {
                ps.addParam("using-graph-uri", defaultGraph);
            }
        }
        if (this.namedGraphURIs != null) {
            for (String namedGraph : this.namedGraphURIs) {
                ps.addParam("using-named-graph-uri", namedGraph);
            }
        }
        return ps;
    }

    public UpdateRequest getUpdateRequest() {
        return this.request;
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String namedGraph) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(namedGraph);
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void setDefaultGraphs(List<String> defaultGraphs) {
        this.defaultGraphURIs = defaultGraphs;
    }

    public void setNamedGraphs(List<String> namedGraphs) {
        this.namedGraphURIs = namedGraphs;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.getContext().put(HTTP_CONTEXT, httpContext);
    }

    public HttpContext getHttpContext() {
        return (HttpContext)this.getContext().get(HTTP_CONTEXT);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setAuthentication(String username, char[] password) {
        this.setAuthenticator(new SimpleAuthenticator(username, password));
    }

    public void setAuthenticator(HttpAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public HttpAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean isUsingAuthentication() {
        return this.authenticator != null;
    }
}

