/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.SyntaxLabels;

public class JsonLDReader
implements ReaderRIOT {
    private ErrorHandler errorHandler = ErrorHandlerFactory.getDefaultErrorHandler();
    private ParserProfile parserProfile = null;
    private LabelToNode labels = SyntaxLabels.createLabelToNode();
    public static String LITERAL = "literal";
    public static String BLANK_NODE = "blank node";
    public static String IRI = "IRI";
    private static final String xsdString = XSDDatatype.XSDstring.getURI();

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ParserProfile getParserProfile() {
        return this.parserProfile;
    }

    @Override
    public void setParserProfile(ParserProfile parserProfile) {
        this.parserProfile = parserProfile;
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
        if (this.parserProfile == null) {
            this.parserProfile = RiotLib.profile(RDFLanguages.JSONLD, baseURI, this.errorHandler);
        }
        try {
            Object jsonObject = JsonUtils.fromReader((Reader)reader);
            this.read$(jsonObject, baseURI, ct, output, context);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        if (this.parserProfile == null) {
            this.parserProfile = RiotLib.profile(RDFLanguages.JSONLD, baseURI, this.errorHandler);
        }
        try {
            Object jsonObject = JsonUtils.fromInputStream((InputStream)in);
            this.read$(jsonObject, baseURI, ct, output, context);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    private void read$(Object jsonObject, String baseURI, ContentType ct, final StreamRDF output, Context context) {
        try {
            JsonLdTripleCallback callback = new JsonLdTripleCallback(){

                public Object call(RDFDataset dataset) {
                    for (Map.Entry namespace2 : dataset.getNamespaces().entrySet()) {
                        output.prefix((String)namespace2.getKey(), (String)namespace2.getValue());
                    }
                    for (String gn : dataset.keySet()) {
                        Object x = dataset.get((Object)gn);
                        if ("@default".equals(gn)) {
                            List triples = (List)x;
                            for (Map t : triples) {
                                Node s = JsonLDReader.this.createNode(t, "subject");
                                Node p = JsonLDReader.this.createNode(t, "predicate");
                                Node o = JsonLDReader.this.createNode(t, "object");
                                Triple triple = JsonLDReader.this.parserProfile.createTriple(s, p, o, -1L, -1L);
                                output.triple(triple);
                            }
                            continue;
                        }
                        List quads = (List)x;
                        Node g = JsonLDReader.this.createURI(gn);
                        for (Map q : quads) {
                            Node s = JsonLDReader.this.createNode(q, "subject");
                            Node p = JsonLDReader.this.createNode(q, "predicate");
                            Node o = JsonLDReader.this.createNode(q, "object");
                            Quad quad = JsonLDReader.this.parserProfile.createQuad(g, s, p, o, -1L, -1L);
                            output.quad(quad);
                        }
                    }
                    return null;
                }
            };
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            JsonLdProcessor.toRDF((Object)jsonObject, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            throw new RiotException(e2);
        }
    }

    private Node createNode(Map<String, Object> tripleMap, String key) {
        Map x = (Map)tripleMap.get(key);
        return this.createNode(x);
    }

    private Node createNode(Map<String, Object> map) {
        String type = (String)map.get("type");
        String lex = (String)map.get("value");
        if (type.equals(IRI)) {
            return this.createURI(lex);
        }
        if (type.equals(BLANK_NODE)) {
            return (Node)this.labels.get(null, lex);
        }
        if (type.equals(LITERAL)) {
            String lang = (String)map.get("language");
            String datatype = (String)map.get("datatype");
            if (Lib.equal(xsdString, datatype)) {
                datatype = null;
            }
            if (lang == null && datatype == null) {
                return this.parserProfile.createStringLiteral(lex, -1L, -1L);
            }
            if (lang != null) {
                return this.parserProfile.createLangLiteral(lex, lang, -1L, -1L);
            }
            RDFDatatype dt = NodeFactory.getType((String)datatype);
            return this.parserProfile.createTypedLiteral(lex, dt, -1L, -1L);
        }
        throw new InternalErrorException("Node is not a IRI, bNode or a literal: " + type);
    }

    private Node createURI(String str2) {
        if (str2.startsWith("_:")) {
            return (Node)this.labels.get(null, str2);
        }
        return this.parserProfile.createURI(str2, -1L, -1L);
    }

    private Node createLiteral(String lex, String datatype, String lang) {
        if (lang == null && datatype == null) {
            return NodeFactory.createLiteral((String)lex);
        }
        if (lang != null) {
            return NodeFactory.createLiteral((String)lex, (String)lang);
        }
        RDFDatatype dt = NodeFactory.getType((String)datatype);
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)dt);
    }
}

